/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventRegisterMatterEntry;
import matteroverdrive.api.matter.IMatterRegistry;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.MatterEntry;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MatterRegistry
implements IMatterRegistry {
    private boolean REGISTRATION_DEBUG = false;
    public boolean CALCULATION_DEBUG = false;
    public boolean AUTOMATIC_CALCULATION = true;
    public boolean CALCULATE_RECIPES = true;
    public boolean CALCULATE_FURNACE = true;
    public boolean hasComplitedRegistration = false;
    private static final int MAX_DEPTH = 8;
    public int basicEntries = 0;
    private Map<String, MatterEntry> entries = new HashMap<String, MatterEntry>();
    private Set<String> blacklist = Collections.synchronizedSet(new HashSet());
    private Set<String> modBlacklist = Collections.synchronizedSet(new HashSet());

    public void preInit(FMLPreInitializationEvent event, ConfigurationHandler configurationHandler) {
        this.REGISTRATION_DEBUG = configurationHandler.getBool("matter registation", "debug", false, "Enables Debug logging for Matter Registration");
        this.CALCULATION_DEBUG = configurationHandler.getBool("matter calculation", "debug", false, "Enables Debug logging for Matter Calculation");
        this.CALCULATE_RECIPES = configurationHandler.getBool("automatic matter calculation from recipe", "matter registry", true, "Enables Matter Calculation from recipes");
        this.CALCULATE_FURNACE = configurationHandler.getBool("automatic matter calculation from furnace", "matter registry", true, "Enables Matter Calculation from furnace recipes");
        this.AUTOMATIC_CALCULATION = configurationHandler.getBool("automatic_calculation", "matter registry", true, "Should the matter registry calculation run on world start when recepie ");
    }

    public MatterEntry register(MatterEntry entry) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventRegisterMatterEntry(entry))) {
            this.debug("Registered: %1$s - %2$s kM", entry.getName(), entry.getMatter());
            this.entries.put(entry.getName(), entry);
        }
        return entry;
    }

    public void saveToFile(String path) throws IOException {
        File file = new File(path);
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream outputStream = new ObjectOutputStream(fileOutputStream);
        outputStream.writeObject(this.entries);
        outputStream.writeUTF("0.4.5");
        outputStream.writeInt(CraftingManager.func_77594_a().func_77592_b().size());
        outputStream.writeInt(this.basicEntries);
        outputStream.writeInt(this.blacklist.size());
        outputStream.writeInt(this.modBlacklist.size());
        outputStream.close();
        fileOutputStream.close();
    }

    public void loadFromFile(String path) throws IOException, ClassNotFoundException {
        File file = new File(path);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream inputStream = new ObjectInputStream(fileInputStream);
            this.entries = (HashMap)inputStream.readObject();
            String version = inputStream.readUTF();
            inputStream.close();
            fileInputStream.close();
            MOLog.info("Registry Loaded with %1$s entries, from version %2$s from: %3$s", this.entries.size(), version, file.getPath());
        }
    }

    public boolean needsCalculation(String path) throws IOException, ClassNotFoundException {
        File file = new File(path);
        String reason = "";
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream inputStream = new ObjectInputStream(fileInputStream);
            HashMap entires = (HashMap)inputStream.readObject();
            String version = inputStream.readUTF();
            int recipeCount = inputStream.readInt();
            int basicEntries = inputStream.readInt();
            int blackListSize = inputStream.readInt();
            int modBlacklistSize = inputStream.readInt();
            inputStream.close();
            fileInputStream.close();
            if (version.equalsIgnoreCase("0.4.5")) {
                if (recipeCount == CraftingManager.func_77594_a().func_77592_b().size()) {
                    if (basicEntries == this.basicEntries) {
                        if (blackListSize == this.blacklist.size() && modBlacklistSize == this.modBlacklist.size()) {
                            for (Map.Entry entry : entires.entrySet()) {
                                if (((MatterEntry)entry.getValue()).getCalculated() || !this.entries.containsKey(entry.getKey()) || this.entries.get(entry.getKey()).equals(entry.getValue())) continue;
                                MOLog.warn("Matter Registry has changed! %1$s changed from %2$s to %3$s. Recalculation required!", entry.getKey(), this.entries.get(entry.getKey()), ((MatterEntry)entry.getValue()).getMatter());
                                return true;
                            }
                            return false;
                        }
                        reason = "Blacklist changed";
                    } else {
                        reason = "Basic Entries size changed";
                    }
                } else {
                    reason = "Recipe List Changed";
                }
            }
        } else {
            reason = "Recipe List File missing";
        }
        MOLog.warn(reason + "! Recalculation required!", new Object[0]);
        return true;
    }

    @Override
    public void addToBlacklist(ItemStack itemStack) {
        this.blacklist.add(this.getKey(itemStack));
    }

    @Override
    public void addToBlacklist(String key) {
        this.blacklist.add(key);
    }

    @Override
    public void addToBlacklist(Item item) {
        this.blacklist.add(this.getKey(item));
    }

    @Override
    public void addToBlacklist(Block block) {
        this.blacklist.add(this.getKey(block));
    }

    @Override
    public boolean blacklisted(Block block) {
        return this.blacklist.contains(this.getKey(block));
    }

    @Override
    public boolean blacklisted(Item item) {
        return this.blacklist.contains(this.getKey(item));
    }

    @Override
    public boolean blacklisted(ItemStack itemStack) {
        return this.blacklisted(this.getKey(itemStack.func_77973_b())) || this.blacklisted(this.getKey(itemStack));
    }

    @Override
    public boolean blacklisted(String key) {
        return this.blacklist.contains(key);
    }

    public boolean blacklistedFromMod(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item != null) {
            return this.modBlacklist.contains(GameRegistry.findUniqueIdentifierFor((Item)item).modId);
        }
        return false;
    }

    public String getKey(Block block) {
        return this.getKey(new ItemStack(block));
    }

    public String getKey(Item item) {
        return this.getKey(new ItemStack(item));
    }

    public String getKey(ItemStack itemStack) {
        try {
            if (itemStack.func_77981_g()) {
                if (itemStack.func_77960_j() > 0 && itemStack.func_77960_j() < Short.MAX_VALUE) {
                    return GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b()) + itemStack.func_77960_j();
                }
                return GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b());
            }
            return GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b());
        }
        catch (Exception e) {
            if (itemStack.func_77973_b() != null) {
                int damage = itemStack.func_77960_j();
                damage = MathHelper.func_76125_a((int)damage, (int)0, (int)itemStack.func_77958_k());
                return itemStack.func_77973_b().func_77657_g(new ItemStack(itemStack.func_77973_b(), 1, damage));
            }
            return null;
        }
    }

    @Override
    public MatterEntry register(Block block, int matter) {
        if (!this.blacklisted(block)) {
            String key = this.getKey(block);
            int configMatter = this.checkInConfig(key);
            if (configMatter > 0) {
                return this.register(new MatterEntry(key, configMatter, 1));
            }
            return this.register(new MatterEntry(key, matter, 1));
        }
        return null;
    }

    @Override
    public MatterEntry register(Item item, int matter) {
        if (!this.blacklisted(item)) {
            String key = this.getKey(item);
            int configMatter = this.checkInConfig(key);
            if (configMatter > 0) {
                return this.register(new MatterEntry(key, configMatter, 1));
            }
            return this.register(new MatterEntry(key, matter, 1));
        }
        return null;
    }

    @Override
    public MatterEntry register(ItemStack itemStack, int matter) {
        if (!this.blacklisted(itemStack)) {
            String key = this.getKey(itemStack);
            int configMatter = this.checkInConfig(key);
            if (configMatter > 0) {
                return this.register(new MatterEntry(key, configMatter, 1));
            }
            return this.register(new MatterEntry(key, matter, 2));
        }
        return null;
    }

    @Override
    public MatterEntry register(String key, int matter) {
        if (!this.blacklisted(key)) {
            int configMatter = this.checkInConfig(key);
            if (configMatter > 0) {
                return this.register(new MatterEntry(key, configMatter, 1));
            }
            return this.register(new MatterEntry(key, matter, 0));
        }
        return null;
    }

    public int checkInConfig(String key) {
        if (MatterOverdrive.configHandler.config.hasKey("matter registry.item overrides", key)) {
            return MatterOverdrive.configHandler.getInt(key, "matter registry.item overrides", -1);
        }
        return -1;
    }

    public MatterEntry registerFromRecipe(ItemStack item) {
        int matter = this.getMatterFromRecipe(item, false, 0, true);
        if (matter > 0) {
            return this.register(new MatterEntry(this.getKey(item), matter, 2));
        }
        return null;
    }

    public MatterEntry getEntry(Block block) {
        return this.getEntry(new ItemStack(block));
    }

    public MatterEntry getEntry(Item item) {
        return this.getEntry(new ItemStack(item));
    }

    public MatterEntry getEntry(ItemStack item) {
        try {
            if (!this.blacklist.contains(this.getKey(item))) {
                MatterEntry e = this.entries.get(this.getKey(item));
                if (e == null) {
                    if (e == null) {
                        this.debug("Could not find matter entry for: %s", item);
                    }
                    if ((e = this.getOreDicionaryEntry(item)) == null) {
                        this.debug("Could not find ore dictionary entry for: %s", item);
                    }
                }
                return e;
            }
            return null;
        }
        catch (Exception e) {
            if (e == null) {
                this.debug("There was a problem getting a Matter Entry for %s.", item);
            }
            return null;
        }
    }

    public MatterEntry getEntry(String name) {
        MatterEntry e = this.entries.get(name);
        if (e == null) {
            for (ItemStack itemStack : OreDictionary.getOres((String)name)) {
                e = this.entries.get(Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()));
                if (e == null) continue;
                return e;
            }
        }
        return e;
    }

    private MatterEntry getOreDicionaryEntry(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length <= 0) {
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                this.debug("Messed up damage for: %s.", stack);
            } else {
                this.debug("No OreDictionary support for: %s", stack);
            }
            return null;
        }
        for (int id : ids) {
            String entryName = OreDictionary.getOreName((int)id);
            this.debug("Searching for OreDictionary key with name: %s for item: %s", entryName, stack);
            MatterEntry e = this.entries.get(entryName);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public int getMatterFromRecipe(Block block, boolean recursive, int depth, boolean calculated) {
        return this.getMatterFromRecipe(new ItemStack(block), recursive, depth, calculated);
    }

    @Override
    public int getMatterFromRecipe(ItemStack item, boolean recursive, int depth, boolean calculated) {
        int matter = 0;
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || !recipeOutput.func_77969_a(item)) continue;
            int m = 0;
            if (recipe instanceof ShapedRecipes) {
                m = this.getMatterFromList(recipeOutput, ((ShapedRecipes)recipe).field_77574_d, recursive, ++depth, calculated);
            } else if (recipe instanceof ShapelessRecipes) {
                m = this.getMatterFromList(recipeOutput, ((ShapelessRecipes)recipe).field_77579_b.toArray(), recursive, ++depth, calculated);
            } else if (recipe instanceof ShapedOreRecipe) {
                m = this.getMatterFromList(recipeOutput, ((ShapedOreRecipe)recipe).getInput(), recursive, ++depth, calculated);
            } else if (recipe instanceof ShapelessOreRecipe) {
                m = this.getMatterFromList(recipeOutput, ((ShapelessOreRecipe)recipe).getInput().toArray(), recursive, ++depth, calculated);
            }
            matter += m;
        }
        return matter;
    }

    @Override
    public void addModToBlacklist(String modID) {
        this.modBlacklist.add(modID);
    }

    public void loadNewItemsFromConfig(ConfigurationHandler c) {
        List category = c.getCategory("matter registry.new items").getOrderedValues();
        for (Property key : category) {
            int value = key.getInt(0);
            if (value <= 0) continue;
            this.register(key.getName(), value);
            ++this.basicEntries;
        }
    }

    public void loadBlacklistFromConfig(ConfigurationHandler c) {
        String[] list;
        for (String value : list = c.getStringList("matter registry", "blacklist")) {
            this.addToBlacklist(value);
        }
    }

    public void loadModBlacklistFromConfig(ConfigurationHandler c) {
        String[] list;
        for (String value : list = c.getStringList("matter registry", "mod_blacklist")) {
            this.addModToBlacklist(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getMatterFromList(ItemStack item, Object[] list, boolean recursive, int depth, boolean calculated) {
        int totalMatter;
        block29: {
            totalMatter = 0;
            if (depth >= 8) break block29;
            for (Object s : list) {
                int tempMatter;
                block28: {
                    MatterEntry tempEntry;
                    block30: {
                        if (s == null) continue;
                        tempMatter = 0;
                        if (!(s instanceof ItemStack) && !(s instanceof Item) && !(s instanceof Block)) break block30;
                        ItemStack stack = null;
                        if (s instanceof ItemStack) {
                            stack = (ItemStack)s;
                        } else if (s instanceof Block) {
                            stack = new ItemStack((Block)s);
                        } else if (s instanceof Item) {
                            stack = new ItemStack((Item)s);
                        }
                        if (stack == null || this.blacklisted(stack) || this.blacklistedFromMod(stack)) {
                            this.debug("%s is blacklisted.", item);
                            return -1;
                        }
                        if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)item)) break block28;
                        tempEntry = this.getEntry(stack);
                        if (tempEntry != null) {
                            tempMatter = tempEntry.getMatter();
                            break block28;
                        } else {
                            if (!recursive) {
                                this.debug("%s cannot be replicated. Contains 0 matter", stack);
                                return 0;
                            }
                            tempMatter = this.getMatterFromRecipe(stack, true, ++depth, calculated);
                            this.debug("searching %s in depth: %s", stack, depth - 1);
                            if (tempMatter > 0) {
                                this.register(stack, tempMatter).setCalculated(calculated);
                                break block28;
                            } else {
                                if (tempMatter < 0) {
                                    this.debug("%s has a blacklisted item in it's recipe", stack);
                                    return -1;
                                }
                                this.debug("%s cannot be replicated. Contains 0 matter", stack);
                                return 0;
                            }
                        }
                    }
                    if (!(s instanceof List)) {
                        this.debug("Element in list is unknown type: %s", s);
                        tempEntry = this.getEntry(s.toString());
                        if (tempEntry != null) {
                            tempMatter = tempEntry.getMatter();
                        }
                    } else {
                        List l = (List)s;
                        boolean first = true;
                        for (Object element : l) {
                            if (element instanceof ItemStack || element instanceof Item || element instanceof Block) {
                                ItemStack stack = null;
                                if (element instanceof ItemStack) {
                                    stack = (ItemStack)element;
                                } else if (element instanceof Item) {
                                    stack = new ItemStack((Item)element);
                                } else if (element instanceof Block) {
                                    stack = new ItemStack((Block)element);
                                }
                                tempEntry = this.getEntry(stack);
                                if (tempEntry != null) {
                                    if (tempEntry.getMatter() > 0) {
                                        if (tempEntry.getMatter() >= tempMatter && !first) continue;
                                        tempMatter = tempEntry.getMatter();
                                        first = false;
                                        continue;
                                    }
                                    this.debug("entry for %s, found in recipe for: %s was blacklisted or costs lower then previous", stack, item);
                                    continue;
                                }
                                if (!recursive) continue;
                                this.debug("Could not find Matter entry for %s, found in recipe for: %s", stack, item);
                                int m = this.getMatterFromRecipe(stack, true, ++depth, calculated);
                                if (m > 0 && (m < tempMatter || first)) {
                                    tempMatter = m;
                                    first = false;
                                    continue;
                                }
                                this.debug("entry for %s, found in recipe for: %s was blacklisted or costs lower then previous", stack, item);
                                continue;
                            }
                            this.debug("Found another type of object in list ot type: %s", element.getClass().toString());
                        }
                        if (tempMatter < 0) {
                            this.debug("%s is invalid.", item);
                            return -1;
                        }
                        if (tempMatter == 0) {
                            this.debug("%s has no items with matter in recipe.", item);
                            return 0;
                        }
                    }
                }
                totalMatter += tempMatter;
            }
        }
        return (int)Math.round((double)totalMatter / (double)item.field_77994_a);
    }

    private int handleReturns(Item item) {
        if (item == Items.field_151129_at || item == Items.field_151131_as || item == Items.field_151117_aB) {
            MatterEntry e = this.getEntry(Items.field_151133_ar);
            if (e != null) {
                return -e.getMatter();
            }
            e = this.getEntry(item);
            if (e != null) {
                return -e.getMatter();
            }
        }
        return 0;
    }

    public void clearCaluclatedEntries() {
        Iterator<Map.Entry<String, MatterEntry>> iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, MatterEntry> entry = iter.next();
            if (!entry.getValue().getCalculated()) continue;
            iter.remove();
        }
    }

    public Map<String, MatterEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<String, MatterEntry> entries) {
        this.entries = entries;
    }

    public void debug(String debug, Object ... params) {
        if (this.REGISTRATION_DEBUG) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof ItemStack)) continue;
                try {
                    params[i] = this.getKey((ItemStack)params[i]);
                    continue;
                }
                catch (Exception e) {
                    MOLog.warn("There was a problem getting ItemStack's name", new Object[0]);
                }
            }
            MOLog.debug(debug, params);
        }
    }
}

