/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.VersionCheckerHandler;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class PlayerEventHandler {
    private VersionCheckerHandler versionCheckerHandler;
    public List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();

    public PlayerEventHandler(ConfigurationHandler configurationHandler) {
        this.versionCheckerHandler = new VersionCheckerHandler();
        configurationHandler.subscribe(this.versionCheckerHandler);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            if (MatterOverdrive.matterRegistry.hasComplitedRegistration) {
                if (!MinecraftServer.func_71276_C().func_71264_H()) {
                    MatterOverdrive.packetPipeline.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries()), (EntityPlayerMP)event.player);
                }
            } else {
                this.players.add((EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MOExtendedProperties extendedProperties;
        AndroidPlayer player;
        if (event.side == Side.CLIENT) {
            this.versionCheckerHandler.onPlayerTick(event);
        }
        if ((player = AndroidPlayer.get(event.player)) != null && event.phase.equals((Object)TickEvent.Phase.START)) {
            if (event.side == Side.CLIENT) {
                this.onAndroidTickClient(player, event);
            } else {
                this.onAndroidServerTick(player, event);
            }
        }
        if ((extendedProperties = MOExtendedProperties.get(event.player)) != null && event.phase.equals((Object)TickEvent.Phase.START)) {
            if (event.side == Side.CLIENT) {
                extendedProperties.update(Side.CLIENT);
            } else {
                extendedProperties.update(Side.SERVER);
            }
        }
        if (event.player.func_71039_bw() && event.side == Side.CLIENT) {
            ItemStack itemstack = event.player.field_71071_by.func_70448_g();
            int itemUseCount = event.player.func_71052_bv();
            if (itemstack != null && itemstack.func_77973_b() instanceof IWeapon && itemUseCount > 0) {
                event.player.func_71008_a(itemstack, itemUseCount);
                if (Minecraft.func_71410_x().field_71462_r != null && event.player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                    event.player.func_71041_bz();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAndroidTickClient(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        if (event.player == Minecraft.func_71410_x().field_71439_g) {
            androidPlayer.onAndroidTick(event.side);
        }
    }

    private void onAndroidServerTick(AndroidPlayer androidPlayer, TickEvent.PlayerTickEvent event) {
        androidPlayer.onAndroidTick(event.side);
    }

    @SubscribeEvent
    public void onPlayerLoadFromFile(PlayerEvent.LoadFromFile event) {
        AndroidPlayer player = AndroidPlayer.get(event.entityPlayer);
        if (player != null) {
            player.onPlayerLoad(event);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityPlayer) {
            MOExtendedProperties extendedProperties;
            AndroidPlayer androidPlayer = AndroidPlayer.get((EntityPlayer)event.target);
            if (androidPlayer != null && androidPlayer.isAndroid()) {
                androidPlayer.sync(event.entityPlayer, EnumSet.allOf(AndroidPlayer.DataType.class), false);
            }
            if ((extendedProperties = MOExtendedProperties.get((EntityPlayer)event.target)) != null) {
                extendedProperties.sync(EnumSet.allOf(PlayerQuestData.DataType.class));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent deathEvent) {
        AndroidPlayer androidPlayer;
        if (deathEvent.entityLiving instanceof EntityPlayer && !((EntityPlayer)deathEvent.entityLiving).field_70170_p.field_72995_K && (androidPlayer = AndroidPlayer.get((EntityPlayer)deathEvent.entityLiving)) != null && androidPlayer.isAndroid()) {
            androidPlayer.onPlayerDeath(deathEvent);
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (MatterOverdrive.matterRegistry.hasComplitedRegistration) {
            for (int i = 0; i < MatterOverdrive.playerEventHandler.players.size(); ++i) {
                MatterOverdrive.packetPipeline.sendTo(new PacketUpdateMatterRegistry(MatterOverdrive.matterRegistry.getEntries()), MatterOverdrive.playerEventHandler.players.get(i));
            }
            MatterOverdrive.playerEventHandler.players.clear();
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        MOExtendedProperties extendedProperties;
        if (event.player != null && (extendedProperties = MOExtendedProperties.get(event.player)) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onPlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        AndroidPlayer androidPlayer;
        if (event.entityPlayer != null && (androidPlayer = AndroidPlayer.get(event.entityPlayer)) != null && androidPlayer.isAndroid()) {
            androidPlayer.triggerEventOnStats((LivingEvent)event);
        }
    }

    @SubscribeEvent
    public void onPlayerScanEvent(MOEventScan event) {
        MOExtendedProperties extendedProperties;
        if (event.getSide() == Side.SERVER && event.entityPlayer != null && (extendedProperties = MOExtendedProperties.get(event.entityPlayer)) != null) {
            extendedProperties.onEvent((Event)event);
        }
    }

    @SubscribeEvent
    public void onBioticStatUse(MOEventBionicStat event) {
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilUpdateEvent event) {
        if (event.left != null && event.right != null && event.left.func_77973_b() == MatterOverdriveItems.portableDecomposer) {
            event.output = event.left.func_77946_l();
            event.materialCost = 1;
            event.cost = 3;
            MatterOverdriveItems.portableDecomposer.addStackToList(event.output, event.right);
        }
    }
}

