/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.handler.thread.VersionCheckThread;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;

public class VersionCheckerHandler
implements IConfigSubscriber {
    private boolean updateInfoDisplayed = false;
    public Future<String> download;
    public static final String[] mirrors = new String[]{"https://raw.githubusercontent.com/Matter-Overdrive-Community-Edition/MatterOverdrive-Community-Edition-1.7.10/1.7.10/Versions.txt"};
    private int currentMirror = 0;
    int lastPoll = 400;
    private boolean checkForUpdates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !this.checkForUpdates) {
            return;
        }
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71278_l() && !MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(event.player.func_146103_bH())) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (this.updateInfoDisplayed) {
            return;
        }
        if (this.currentMirror < mirrors.length && this.download == null) {
            this.download = MatterOverdrive.threadPool.submit(new VersionCheckThread(mirrors[this.currentMirror]));
            ++this.currentMirror;
        }
        if (this.download != null && this.download.isDone()) {
            String result = null;
            try {
                result = this.download.get();
            }
            catch (InterruptedException e) {
                MOLog.log(Level.ERROR, e, "Version checking from '%1$s' was interrupted", mirrors[this.currentMirror - 1]);
            }
            catch (ExecutionException e) {
                MOLog.log(Level.ERROR, e, "Version checking from '%1$s' has failed", mirrors[this.currentMirror - 1]);
            }
            finally {
                if (result != null) {
                    try {
                        this.updateInfoDisplayed = this.constructVersionAndCheck(result, event.player);
                    }
                    catch (Exception e) {
                        MOLog.log(Level.ERROR, e, "There was a problem while decoding the update info from website.", new Object[0]);
                    }
                }
                this.download.cancel(false);
                this.download = null;
            }
        }
    }

    private boolean constructVersionAndCheck(String jsonText, EntityPlayer player) {
        JsonParser parser = new JsonParser();
        JsonObject root = parser.parse(jsonText).getAsJsonArray().get(0).getAsJsonObject();
        SimpleDateFormat websiteDatePraser = new SimpleDateFormat("y-M-d");
        SimpleDateFormat modDateFormat = new SimpleDateFormat("d.M.y");
        String websiteDateString = root.get("date").getAsString();
        websiteDateString = websiteDateString.substring(0, websiteDateString.indexOf(84));
        Date websiteDate = null;
        Date modDate = null;
        try {
            websiteDate = websiteDatePraser.parse(websiteDateString);
        }
        catch (ParseException e) {
            MOLog.warn("Website date was incorrect", e);
        }
        try {
            modDate = modDateFormat.parse(Reference.VERSION_DATE);
        }
        catch (ParseException e) {
            MOLog.warn("Mod version date was incorrect", e);
        }
        if (modDate != null && websiteDate != null) {
            if (modDate.before(websiteDate)) {
                ChatComponentText chat = new ChatComponentText(EnumChatFormatting.GOLD + "[Matter Overdrive] " + EnumChatFormatting.WHITE + MOStringHelper.translateToLocal("alert.new_update"));
                ChatStyle style = new ChatStyle();
                player.func_145747_a((IChatComponent)chat);
                chat = new ChatComponentText("");
                IChatComponent versionName = new ChatComponentText(root.get("title").getAsString() + " ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.AQUA));
                chat.func_150257_a(versionName);
                chat.func_150258_a(EnumChatFormatting.WHITE + "[");
                style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/matter-overdrive-community-edition/"));
                style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ChatComponentTranslation("info.mo.updater.hover", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW))));
                style.func_150238_a(EnumChatFormatting.GREEN);
                chat.func_150257_a((IChatComponent)new ChatComponentTranslation("info.mo.updater.download", new Object[0])).func_150255_a(style);
                chat.func_150258_a(EnumChatFormatting.WHITE + "]");
                player.func_145747_a((IChatComponent)chat);
                chat = new ChatComponentText(root.get("excerpt").getAsString().replaceAll("\\<.*?\\>", ""));
                style = new ChatStyle();
                style.func_150238_a(EnumChatFormatting.GRAY);
                chat.func_150255_a(style);
                player.func_145747_a((IChatComponent)chat);
                return true;
            }
            MOLog.info("Matter Overdrive Version %1$s is up to date. From '%2$s'", root.get("title").getAsString(), mirrors[this.currentMirror - 1]);
        }
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        String comment = "Should Matter Overdrive check for newer versions, every time the world starts";
        this.checkForUpdates = config.getBool("version_check", "client", true, comment);
        config.config.get((String)"client", (String)"version_check", (boolean)true).comment = comment;
    }
}

