/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.quest;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.Quest;

public class Quests {
    private static final int MIN_QUEST_BIT = 0;
    private static final int MAX_QUEST_IDS = Short.MAX_VALUE;
    private BitSet bitSet = new BitSet(Short.MAX_VALUE);
    private Map<Integer, IQuest> questMap = new HashMap<Integer, IQuest>();
    private Map<IQuest, Integer> questIntegerMap = new HashMap<IQuest, Integer>();
    private Map<String, IQuest> stringQuestMap = new HashMap<String, IQuest>();
    public final Random random = new Random();

    public IQuest getQuestWithID(int questID) {
        return this.questMap.get(questID);
    }

    public int getQuestID(IQuest quest) {
        return this.questIntegerMap.get(quest);
    }

    public IQuest getQuestByName(String name) {
        return this.stringQuestMap.get(name);
    }

    public void registerQuest(String name, Quest quest) {
        if (this.questIntegerMap.containsKey(name)) {
            throw new RuntimeException(name + " Quest is already registered");
        }
        int id = this.bitSet.nextClearBit(0);
        this.questMap.put(id, quest);
        this.questIntegerMap.put(quest, id);
        this.stringQuestMap.put(name, quest);
        this.bitSet.set(id, true);
    }

    public void registerQuestAt(Integer id, String name, IQuest quest) {
        this.questMap.put(id, quest);
        this.questIntegerMap.put(quest, id);
        this.bitSet.set((int)id, true);
        this.stringQuestMap.put(name, quest);
    }

    public Set<String> getAllQuestName() {
        return this.stringQuestMap.keySet();
    }
}

