/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.weapon;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.handler.weapon.CommonWeaponHandler;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.network.packet.bi.PacketWeaponTick;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;

@SideOnly(value=Side.CLIENT)
public class ClientWeaponHandler
extends CommonWeaponHandler {
    private static final float RECOIL_RESET_SPEED = 0.03f;
    public static float ZOOM_TIME;
    public static float RECOIL_TIME;
    public static float RECOIL_AMOUNT;
    private Map<IWeapon, Integer> shotTracker = new HashMap<IWeapon, Integer>();
    private float lastMouseSensitivity;

    public void registerWeapon(IWeapon weapon) {
        this.shotTracker.put(weapon, 0);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            for (IWeapon item : this.shotTracker.keySet()) {
                int oldTime = this.shotTracker.get(item);
                if (oldTime <= 0) continue;
                this.shotTracker.put(item, oldTime - 1);
            }
            this.manageWeaponView();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.RenderTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            EntityClientPlayerMP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            ZOOM_TIME = entityPlayer.func_70694_bm() != null && entityPlayer.func_70694_bm().func_77973_b() instanceof IWeapon ? MOMathHelper.Lerp(ZOOM_TIME, ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).isWeaponZoomed((EntityPlayer)entityPlayer, entityPlayer.func_70694_bm()) ? 1.0f : 0.0f, event.renderTickTime * 0.2f) : MOMathHelper.Lerp(ZOOM_TIME, 0.0f, 0.2f);
            if (ZOOM_TIME == 0.0f) {
                this.lastMouseSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
            } else {
                Minecraft.func_71410_x().field_71474_y.field_74341_c = entityPlayer.func_70694_bm() != null && entityPlayer.func_70694_bm().func_77973_b() instanceof IWeapon ? this.lastMouseSensitivity * (1.0f - ZOOM_TIME * ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).getZoomMultiply((EntityPlayer)entityPlayer, entityPlayer.func_70694_bm())) : this.lastMouseSensitivity;
            }
            if (RECOIL_TIME > 0.0f) {
                RECOIL_TIME = Math.max(0.0f, RECOIL_TIME - 0.03f);
            }
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_70694_bm() != null && Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77973_b() instanceof IWeapon) {
            event.newfov -= event.fov * ZOOM_TIME * ((IWeapon)Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77973_b()).getZoomMultiply((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.func_70694_bm());
        }
    }

    private void manageWeaponView() {
        for (Object playerObj : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)playerObj;
            ItemStack currentitem = player.func_71045_bC();
            if (currentitem == null || !(currentitem.func_77973_b() instanceof IWeapon) || !((IWeapon)currentitem.func_77973_b()).isAlwaysEquipped(currentitem)) continue;
            if (player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                currentitem.func_77964_b(0);
                continue;
            }
            currentitem.func_77964_b(1);
            player.func_71008_a(currentitem, player.func_71052_bv());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendWeaponTickToServer(World world, PacketFirePlasmaShot firePlasmaShot) {
        MatterOverdrive.packetPipeline.sendToServer(new PacketWeaponTick(world.func_72820_D(), firePlasmaShot));
    }

    public boolean shootDelayPassed(IWeapon item) {
        return this.shotTracker.get(item) <= 0;
    }

    public void addShootDelay(IWeapon item, ItemStack weaponStack) {
        if (this.shotTracker.containsKey(item)) {
            this.shotTracker.put(item, this.shotTracker.get(item) + item.getShootCooldown(weaponStack));
        }
    }

    public void addReloadDelay(IWeapon weapon, int delay) {
        if (this.shotTracker.containsKey(weapon)) {
            this.shotTracker.put(weapon, this.shotTracker.get(weapon) + delay);
        }
    }

    public float getEquippedWeaponAccuracyPercent(EntityPlayer entityPlayer) {
        if (entityPlayer.func_70694_bm() != null && entityPlayer.func_70694_bm().func_77973_b() instanceof IWeapon) {
            return ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).getAccuracy(entityPlayer.func_70694_bm(), (EntityLivingBase)entityPlayer, ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).isWeaponZoomed(entityPlayer, entityPlayer.func_70694_bm())) / ((IWeapon)entityPlayer.func_70694_bm().func_77973_b()).getMaxHeat(entityPlayer.func_70694_bm());
        }
        return 0.0f;
    }
}

