/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.imc;

import cpw.mods.fml.common.event.FMLInterModComms;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.handler.recipes.InscriberRecipes;
import matteroverdrive.util.MOLog;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class MOIMCHandler {
    public static void imcCallback(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(MOIMCHandler::handleMessage);
    }

    public static void handleMessage(FMLInterModComms.IMCMessage msg) {
        switch (msg.key) {
            case "registry:blacklist:add": {
                MOIMCHandler.handleItemBlacklistRegistration(msg);
                break;
            }
            case "registry:blacklist:mod:add": {
                MatterOverdrive.matterRegistry.addModToBlacklist(msg.getStringValue());
                break;
            }
            case "registry:inscriber:recipe:add": {
                MOIMCHandler.handleInscriberRecipeRegistration(msg);
                break;
            }
            case "registry:matter:add": {
                MOIMCHandler.handleMatterRegistration(msg);
            }
        }
    }

    private static void handleMatterRegistration(FMLInterModComms.IMCMessage msg) {
        if (!msg.isNBTMessage()) {
            MOLog.warn("Invalid message type for Matter Registration. Message needs to be of type NBT", new Object[0]);
            return;
        }
        try {
            NBTTagCompound data = msg.getNBTValue();
            if (MOIMCHandler.containsAllTags(data, "Matter")) {
                int matter = data.func_74762_e("Matter");
                if (data.func_74764_b("Item")) {
                    ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Item"));
                    MatterOverdrive.matterRegistry.register(itemStack, matter);
                } else if (data.func_74764_b("Ore")) {
                    String oreName = data.func_74779_i("Ore");
                    MatterOverdrive.matterRegistry.register(oreName, matter);
                }
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to register an Item in the Matter Registry from: %s", msg.getSender());
        }
    }

    private static void handleItemBlacklistRegistration(FMLInterModComms.IMCMessage msg) {
        if (!msg.isItemStackMessage()) {
            MOLog.warn("Invalid message type for Matter Blacklist Registration. Message needs to be of type Item Stack", new Object[0]);
            return;
        }
        ItemStack itemStack = msg.getItemStackValue();
        if (itemStack != null) {
            MatterOverdrive.matterRegistry.addToBlacklist(itemStack);
        }
    }

    private static void handleInscriberRecipeRegistration(FMLInterModComms.IMCMessage msg) {
        if (!msg.isNBTMessage()) {
            MOLog.error("Invalid message format for Inscriber Recipe registration. Message needs to be of type NBT", new Object[0]);
            return;
        }
        try {
            NBTTagCompound data = msg.getNBTValue();
            if (MOIMCHandler.containsAllTags(data, "Main", "Sec", "Output", "Energy", "Time")) {
                ItemStack mainStack = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Main"));
                ItemStack secStack = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Sec"));
                ItemStack output = ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Output"));
                int energy = data.func_74762_e("Energy");
                int time = data.func_74762_e("Time");
                if (mainStack != null && secStack != null && output != null) {
                    InscriberRecipe recipe = new InscriberRecipe(mainStack, secStack, output, energy, time);
                    InscriberRecipes.registerRecipe(recipe);
                }
            }
        }
        catch (Exception e) {
            MOLog.log(Level.ERROR, e, "There was a problem while trying to register an Inscriber Recipe from: %s", msg.getSender());
        }
    }

    private static boolean containsAllTags(NBTTagCompound tagCompound, String ... tags) {
        for (String tag : tags) {
            if (tagCompound.func_74764_b(tag)) continue;
            return false;
        }
        return true;
    }
}

