/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.Quest;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.WeightedRandomQuest;
import matteroverdrive.gui.GuiQuestPreview;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class Contract
extends MOBaseItem {
    public Contract(String name) {
        super(name);
    }

    public QuestStack getQuest(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            QuestStack questStack = QuestStack.loadFromNBT(itemStack.func_77978_p());
            return questStack;
        }
        return null;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        QuestStack questStack = QuestStack.loadFromNBT(itemstack.func_77978_p());
        if (questStack != null) {
            for (int i = 0; i < questStack.getObjectivesCount(player); ++i) {
                infos.add(MatterOverdrive.questFactory.getFormattedQuestObjective(player, questStack, i));
            }
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            QuestStack questStack = QuestStack.loadFromNBT(itemStack.func_77978_p());
            return questStack.getTitle();
        }
        return super.func_77653_i(itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (world.field_72995_K) {
            this.openGui(itemstack);
        } else {
            QuestStack questStack = this.getQuest(itemstack);
            if (questStack == null) {
                Quest quest = ((WeightedRandomQuest)WeightedRandom.func_76271_a((Random)field_77697_d, MatterOverdriveQuests.contractGeneration)).getQuest();
                questStack = MatterOverdrive.questFactory.generateQuestStack(field_77697_d, quest);
                NBTTagCompound questTag = new NBTTagCompound();
                questStack.writeToNBT(questTag);
                itemstack.func_77982_d(questTag);
            }
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(ItemStack stack) {
        QuestStack questStack = this.getQuest(stack);
        if (questStack != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiQuestPreview(this.getQuest(stack)));
        }
    }
}

