/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOPhysicsHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class DataPad
extends MOBaseItem
implements IBlockScanner {
    @SideOnly(value=Side.CLIENT)
    public static MachineSound scanningSound;

    public DataPad(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (world.field_72995_K && this.hasGui(itemstack)) {
            this.openGui(itemstack);
        }
        return itemstack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (!entityPlayer.func_70093_af() && world.func_147439_a(x, y, z) != Blocks.field_150350_a && this.canScan(itemStack, world.func_147439_a(x, y, z))) {
            entityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
            if (world.field_72995_K) {
                this.playSound(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
            } else {
                this.setLastBlock(itemStack, world.func_147439_a(x, y, z));
            }
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack scanner) {
        return 40;
    }

    @Override
    public boolean hasDetails(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(ItemStack stack) {
        try {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataPad(stack));
        }
        catch (Exception e) {
            MOLog.error("There was a problem while trying to open the Data Pad Gui", e, new Object[0]);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        EntityPlayer player;
        super.func_77663_a(itemStack, world, entity, p_77663_4_, p_77663_5_);
        if (world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_71039_bw()) {
            this.stopScanSounds();
        }
    }

    public ItemStack func_77654_b(ItemStack scanner, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventScan(player, scanner, this.getScanningPos(scanner, player)))) {
                this.stopScanSounds();
            }
        } else {
            MOEventScan event = new MOEventScan(player, scanner, this.getScanningPos(scanner, player));
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                if (this.destroysBlocks(scanner) && world.func_72962_a(player, event.position.field_72311_b, event.position.field_72312_c, event.position.field_72309_d)) {
                    world.func_147468_f(event.position.field_72311_b, event.position.field_72312_c, event.position.field_72309_d);
                }
                SoundHandler.PlaySoundAt(world, "scanner_success", (Entity)player);
            }
        }
        return scanner;
    }

    public void onUsingTick(ItemStack scanner, EntityPlayer player, int count) {
        MovingObjectPosition hit = this.getScanningPos(scanner, player);
        if (hit != null) {
            Block lastBlock;
            if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (lastBlock = this.getLastBlock(scanner)) != null && lastBlock != player.field_70170_p.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d)) {
                player.func_71041_bz();
            }
        } else if (player.field_70170_p.field_72995_K) {
            this.stopScanSounds();
            player.func_71034_by();
        }
    }

    public Block getLastBlock(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return Block.func_149729_e((int)itemStack.func_77978_p().func_74762_e("LastBlock"));
        }
        return null;
    }

    public void setLastBlock(ItemStack itemStack, Block block) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        int blockID = Block.func_149682_b((Block)block);
        if (itemStack.func_77978_p().func_74762_e("LastBlock") != blockID) {
            itemStack.func_77978_p().func_74768_a("LastBlock", blockID);
        }
    }

    public void func_77615_a(ItemStack scanner, World world, EntityPlayer player, int count) {
        if (world.field_72995_K) {
            this.stopScanSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(double x, double y, double z) {
        if (scanningSound == null) {
            scanningSound = new MachineSound(new ResourceLocation("mo:scanner_scanning"), (float)x, (float)y, (float)z, 0.6f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)scanningSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopScanSounds() {
        if (scanningSound != null) {
            scanningSound.stopPlaying();
            scanningSound = null;
        }
    }

    @Override
    public MovingObjectPosition getScanningPos(ItemStack itemStack, EntityPlayer player) {
        return MOPhysicsHelper.rayTrace((EntityLivingBase)player, player.field_70170_p, 5.0, 0.0f, Vec3.func_72443_a((double)0.0, (double)(player.field_70170_p.field_72995_K ? 0.0 : (double)player.func_70047_e()), (double)0.0), true, false);
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.block;
    }

    public void addToScanWhitelist(ItemStack itemStack, Block block) {
        String id = Block.field_149771_c.func_148750_c((Object)block);
        if (id != null) {
            NBTTagList list = itemStack.func_77978_p().func_150295_c("whitelist", 8);
            list.func_74742_a((NBTBase)new NBTTagString(id));
            itemStack.func_77978_p().func_74782_a("whitelist", (NBTBase)list);
        }
    }

    public void setOrdering(ItemStack stack, int order) {
        this.TagCompountCheck(stack);
        stack.func_77978_p().func_74768_a("Ordering", order);
    }

    public void setOpenGuide(ItemStack stack, int guideID) {
        this.TagCompountCheck(stack);
        stack.func_77978_p().func_74768_a("guideID", guideID);
    }

    public void setOpenPage(ItemStack stack, int page) {
        this.TagCompountCheck(stack);
        stack.func_77978_p().func_74768_a("page", page);
    }

    public void setCategory(ItemStack stack, String category) {
        this.TagCompountCheck(stack);
        stack.func_77978_p().func_74778_a("Category", category);
    }

    public void setSelectedActiveQuest(ItemStack itemStack, int quest) {
        this.TagCompountCheck(itemStack);
        itemStack.func_77978_p().func_74777_a("SelectedActiveQuest", (short)quest);
    }

    public int getGuideID(ItemStack stack) {
        this.TagCompountCheck(stack);
        if (this.hasOpenGuide(stack)) {
            return stack.func_77978_p().func_74762_e("guideID");
        }
        return -1;
    }

    public int getPage(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_74762_e("page");
    }

    public boolean hasOpenGuide(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_150297_b("guideID", 3);
    }

    public int getOrdering(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Ordering", 8)) {
            return stack.func_77978_p().func_74762_e("Ordering");
        }
        return 2;
    }

    public String getCategory(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74779_i("Category");
        }
        return "";
    }

    public int getActiveSelectedQuest(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74765_d("SelectedActiveQuest");
        }
        return 0;
    }

    @Override
    public boolean destroysBlocks(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74767_n("Destroys");
        }
        return false;
    }

    public boolean canScan(ItemStack itemStack, Block block) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_150297_b("whitelist", 9)) {
            NBTTagList tagList = itemStack.func_77978_p().func_150295_c("whitelist", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                if (!tagList.func_150307_f(i).equals(Block.field_149771_c.func_148750_c((Object)block))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasGui(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return !itemStack.func_77978_p().func_74767_n("nogui");
        }
        return true;
    }
}

