/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import matteroverdrive.api.matter.IMatterItem;
import matteroverdrive.api.matter.IRecyclable;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class MatterDust
extends MOBaseItem
implements IRecyclable,
IMatterItem {
    boolean isRefined;

    public MatterDust(String name, boolean refined) {
        super(name);
        this.isRefined = refined;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        if (!this.isRefined) {
            infos.add(EnumChatFormatting.BLUE + "Potential Matter: " + MatterHelper.formatMatter(itemstack.func_77960_j()));
        }
    }

    public int getDamage(ItemStack stack) {
        this.TagCompountCheck(stack);
        return stack.func_77978_p().func_74762_e("Matter");
    }

    public void setMatter(ItemStack itemStack, int matter) {
        this.TagCompountCheck(itemStack);
        itemStack.func_77978_p().func_74768_a("Matter", matter);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return !this.isRefined;
    }

    @Override
    public ItemStack getOutput(ItemStack from) {
        ItemStack newItemStack = new ItemStack((Item)MatterOverdriveItems.matter_dust_refined);
        MatterOverdriveItems.matter_dust_refined.setMatter(newItemStack, from.func_77960_j());
        return newItemStack;
    }

    @Override
    public int getRecycleMatter(ItemStack stack) {
        return stack.func_77960_j();
    }

    @Override
    public boolean canRecycle(ItemStack stack) {
        if (stack.func_77973_b() instanceof MatterDust) {
            return !((MatterDust)stack.func_77973_b()).isRefined;
        }
        return false;
    }

    @Override
    public int getMatter(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof MatterDust && ((MatterDust)itemStack.func_77973_b()).isRefined) {
            return itemStack.func_77960_j();
        }
        return 0;
    }
}

