/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkFilter;
import matteroverdrive.client.data.Color;
import matteroverdrive.data.BlockPos;
import matteroverdrive.items.FlashDrive;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkFlashDrive
extends FlashDrive
implements IMatterNetworkFilter {
    public NetworkFlashDrive(String name, Color color) {
        super(name, color);
        this.func_77625_d(1);
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        if (itemstack.func_77942_o()) {
            NBTTagList list = itemstack.func_77978_p().func_150295_c("CONNECTIONS", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                BlockPos pos = new BlockPos(list.func_150305_b(i));
                Block block = pos.getBlock(player.field_70170_p);
                if (block == null) continue;
                infos.add(String.format("[%s,%s,%s] %s", pos.x, pos.y, pos.z, block != Blocks.field_150350_a ? block.func_149732_F() : "Unknown"));
            }
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IMatterNetworkConnection) {
            BlockPos connectionPosition = ((IMatterNetworkConnection)tileEntity).getPosition();
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            boolean hasPos = false;
            NBTTagList list = itemStack.func_77978_p().func_150295_c("CONNECTIONS", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                BlockPos pos = new BlockPos(list.func_150305_b(i));
                if (!pos.equals(connectionPosition)) continue;
                hasPos = true;
                list.func_74744_a(i);
                break;
            }
            if (!hasPos) {
                NBTTagCompound posNBT = new NBTTagCompound();
                connectionPosition.writeToNBT(posNBT);
                list.func_74742_a((NBTBase)posNBT);
            }
            itemStack.func_77978_p().func_74782_a("CONNECTIONS", (NBTBase)list);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound getFilter(ItemStack stack) {
        return stack.func_77978_p();
    }
}

