/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class PatternDrive
extends MOBaseItem
implements IMatterPatternStorage {
    private IIcon storageFull;
    private IIcon storagePartiallyFull;
    int capacity;

    public PatternDrive(String name, int capacity) {
        super(name);
        this.capacity = capacity;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        this.field_77791_bV = p_94581_1_.func_94245_a(this.func_111208_A());
        this.storageFull = p_94581_1_.func_94245_a(this.func_111208_A() + "_full");
        this.storagePartiallyFull = p_94581_1_.func_94245_a(this.func_111208_A() + "_partially_full");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        switch (damage) {
            case 2: {
                return this.storageFull;
            }
            case 1: {
                return this.storagePartiallyFull;
            }
        }
        return this.field_77791_bV;
    }

    public int getDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150296_c().size() > 0) {
            if (stack.func_77978_p().func_150296_c().size() < this.getCapacity(stack)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        if (itemstack.func_77942_o()) {
            ItemPattern[] patterns = this.getPatterns(itemstack);
            for (int i = 0; i < patterns.length; ++i) {
                String displayName;
                ItemStack stack = patterns[i].toItemStack(false);
                try {
                    displayName = stack.func_82833_r();
                }
                catch (Exception e) {
                    displayName = "Unknown";
                }
                if (MatterHelper.getMatterAmountFromItem(stack) > 0) {
                    infos.add(MatterDatabaseHelper.getPatternInfoColor(patterns[i].getProgress()) + displayName + " [" + patterns[i].getProgress() + "%]");
                } else {
                    infos.add(EnumChatFormatting.RED + "[Invalid] " + MatterDatabaseHelper.getPatternInfoColor(patterns[i].getProgress()) + displayName + " [" + patterns[i].getProgress() + "%]");
                }
                if (i <= 8) continue;
                infos.add(EnumChatFormatting.YELLOW + String.format("...and %s more patterns.", patterns.length - 9));
                break;
            }
        }
    }

    @Override
    public void InitTagCompount(ItemStack stack) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74777_a("Capacity", (short)this.capacity);
        NBTTagList itemList = new NBTTagList();
        tagCompound.func_74782_a("items", (NBTBase)itemList);
        stack.func_77982_d(tagCompound);
    }

    @Override
    public ItemPattern[] getPatterns(ItemStack storage) {
        this.TagCompountCheck(storage);
        NBTTagList tagList = storage.func_77978_p().func_150295_c("items", 10);
        ItemPattern[] patterns = new ItemPattern[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemPattern pattern;
            patterns[i] = pattern = new ItemPattern(tagList.func_150305_b(i));
        }
        return patterns;
    }

    @Override
    public boolean addItem(ItemStack storage, ItemStack itemStack, int initialAmount, boolean simulate) {
        int itemProgress;
        this.TagCompountCheck(storage);
        NBTTagList patternsTagList = storage.func_77978_p().func_150295_c("items", 10);
        if (patternsTagList.func_74745_c() < this.getCapacity(storage) && MatterHelper.CanScan(itemStack) && (itemProgress = MatterDatabaseHelper.getItemStackProgress(storage, itemStack)) < 100) {
            if (!simulate) {
                MatterDatabaseHelper.addProgressToPatternStorage(storage, itemStack, initialAmount, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemPattern getPattern(ItemStack storage, ItemStack item) {
        this.TagCompountCheck(storage);
        return MatterDatabaseHelper.getPatternFromStorage(storage, item);
    }

    @Override
    public int getCapacity(ItemStack item) {
        this.TagCompountCheck(item);
        return item.func_77978_p().func_74765_d("Capacity");
    }

    public void clearStorage(ItemStack itemStack) {
        if (MatterHelper.isMatterPatternStorage(itemStack)) {
            itemStack.func_77982_d(null);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.clearStorage(itemStack);
        }
        return itemStack;
    }
}

