/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.text.DecimalFormat;
import java.util.List;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.items.includes.MOItemEnergyContainer;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class PortableDecomposer
extends MOItemEnergyContainer {
    private int defaultMatter;
    private float defaultMatterRatio;

    public PortableDecomposer(String name, int capacity, int chargeSpeed, int defaultMatter, float defaultMatterRatio) {
        super(name, capacity, chargeSpeed, 0);
        this.defaultMatter = defaultMatter;
        this.defaultMatterRatio = defaultMatterRatio;
    }

    @Override
    public void addDetails(ItemStack itemstack, EntityPlayer player, List infos) {
        super.addDetails(itemstack, player, infos);
        infos.add(String.format("%s/%s %s", DecimalFormat.getIntegerInstance().format(this.getMatter(itemstack)), Float.valueOf(this.getMaxMatter(itemstack)), " kM"));
        if (itemstack.func_77978_p() != null) {
            NBTTagList list = itemstack.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack s = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                infos.add(EnumChatFormatting.GRAY + s.func_82833_r());
            }
        }
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (world.func_147438_o(x, y, z) instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)world.func_147438_o(x, y, z);
            FluidStack fluidStack = new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, this.getMatter(itemStack));
            int filled = fluidHandler.fill(ForgeDirection.getOrientation((int)side), fluidStack, true);
            this.setMatter(itemStack, Math.max(0, fluidStack.amount - filled));
            return true;
        }
        return false;
    }

    public int getMatter(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return itemStack.func_77978_p().func_74762_e("Matter");
        }
        return 0;
    }

    public void setMatter(ItemStack itemStack, float matter) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74776_a("Matter", matter);
    }

    public float getMaxMatter(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("MaxMatter")) {
            return itemStack.func_77978_p().func_74760_g("MaxMatter");
        }
        return this.defaultMatter;
    }

    public boolean isStackListed(ItemStack decomposer, ItemStack itemStack) {
        if (decomposer.func_77978_p() != null && MatterHelper.containsMatter(itemStack)) {
            NBTTagList stackList = decomposer.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < stackList.func_74745_c(); ++i) {
                ItemStack s = ItemStack.func_77949_a((NBTTagCompound)stackList.func_150305_b(i));
                if (!s.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public void addStackToList(ItemStack decomposer, ItemStack itemStack) {
        if (decomposer.func_77978_p() == null) {
            decomposer.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = decomposer.func_77978_p().func_150295_c("Items", 10);
        if (MatterHelper.containsMatter(itemStack)) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            itemStack.func_77955_b(tagCompound);
            list.func_74742_a((NBTBase)tagCompound);
        }
        decomposer.func_77978_p().func_74782_a("Items", (NBTBase)list);
    }

    public void decomposeItem(ItemStack decomposer, ItemStack itemStack) {
        if (MatterHelper.containsMatter(itemStack) && this.isStackListed(decomposer, itemStack)) {
            float matterFromItem = (float)MatterHelper.getMatterAmountFromItem(itemStack) * this.defaultMatterRatio;
            int energyForItem = MathHelper.func_76123_f((float)(matterFromItem / this.defaultMatterRatio));
            float freeMatter = this.getMaxMatter(decomposer) - (float)this.getMatter(decomposer);
            if (freeMatter > 0.0f && this.getEnergyStored(decomposer) > energyForItem) {
                int canTakeCount = (int)(freeMatter / matterFromItem);
                int itemsTaken = Math.min(canTakeCount, itemStack.field_77994_a);
                itemsTaken = Math.min(itemsTaken, this.getEnergyStored(decomposer) / energyForItem);
                this.setEnergyStored(decomposer, this.getEnergyStored(decomposer) - itemsTaken * energyForItem);
                this.setMatter(decomposer, (float)this.getMatter(decomposer) + (float)itemsTaken * matterFromItem);
                itemStack.field_77994_a = Math.max(0, itemStack.field_77994_a - itemsTaken);
            }
        }
    }
}

