/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.weapon.MOEventEnergyWeapon;
import matteroverdrive.api.inventory.IEnergyPack;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponScope;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.init.MatterOverdriveEnchantments;
import matteroverdrive.items.includes.MOItemEnergyContainer;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.network.packet.server.PacketReloadEnergyWeapon;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.EntityDamageSourcePhaser;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class EnergyWeapon
extends MOItemEnergyContainer
implements IWeapon {
    public static final String CUSTOM_DAMAGE_TAG = "CustomDamage";
    public static final String CUSTOM_ACCURACY_TAG = "CustomAccuracy";
    public static final String CUSTOM_RANGE_TAG = "CustomRange";
    public static final String CUSTOM_SPEED_TAG = "CustomSpeed";
    public static final String CUSTOM_DAMAGE_MULTIPLY_TAG = "CustomDamageMultiply";
    public static final String CUSTOM_ACCURACY_MULTIPLY_TAG = "CustomAccuracyMultiply";
    public static final String CUSTOM_RANGE_MULTIPLY_TAG = "CustomRangeMultiply";
    public static final String CUSTOM_SPEED_MULTIPLY_TAG = "CustomSpeedMultiply";
    private final int defaultRange;
    private DecimalFormat damageFormater = new DecimalFormat("#.##");
    protected boolean leftClickFire;

    public EnergyWeapon(String name, int capacity, int maxReceive, int maxExtract, int defaultRange) {
        super(name, capacity, maxReceive, maxExtract);
        this.defaultRange = defaultRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        ItemStack unpowered = new ItemStack(item);
        ItemStack powered = new ItemStack(item);
        this.setEnergyStored(powered, this.getMaxEnergyStored(powered));
        list.add(unpowered);
        list.add(powered);
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public int getItemStackLimit(ItemStack item) {
        return 1;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean isHolding) {
        if (!world.field_72995_K) {
            this.manageCooling(itemStack);
        } else if (entity instanceof EntityPlayer && entity == Minecraft.func_71410_x().field_71439_g && isHolding && Minecraft.func_71410_x().field_71462_r == null) {
            this.onShooterClientUpdate(itemStack, world, (EntityPlayer)entity, true);
        }
    }

    @Override
    public void addDetails(ItemStack weapon, EntityPlayer player, List infos) {
        super.addDetails(weapon, player, infos);
        String energyInfo = EnumChatFormatting.DARK_RED + "Power Use: " + MOEnergyHelper.formatEnergy(null, this.getEnergyUse(weapon) * 20) + "/s";
        float energyMultiply = (float)this.getEnergyUse(weapon) / (float)this.getBaseEnergyUse(weapon);
        if (energyMultiply != 1.0f) {
            energyInfo = energyInfo + " (" + DecimalFormat.getPercentInstance().format(energyMultiply) + ")";
        }
        infos.add(energyInfo);
        infos.add("");
        infos.add(this.addStatWithMultiplyInfo("Damage", this.damageFormater.format(this.getWeaponScaledDamage(weapon, (EntityLivingBase)player)), this.getWeaponScaledDamage(weapon, (EntityLivingBase)player) / this.getWeaponBaseDamage(weapon), ""));
        infos.add(this.addStatWithMultiplyInfo("DPS", this.damageFormater.format(this.getWeaponScaledDamage(weapon, (EntityLivingBase)player) / (float)this.getShootCooldown(weapon) * 20.0f), 1.0, ""));
        infos.add(this.addStatWithMultiplyInfo("Speed", (int)(20.0 / (double)this.getShootCooldown(weapon) * 60.0), (double)this.getBaseShootCooldown(weapon) / (double)this.getShootCooldown(weapon), " s/m"));
        infos.add(this.addStatWithMultiplyInfo("Range", this.getRange(weapon), (double)this.getRange(weapon) / (double)this.defaultRange, "b"));
        infos.add(this.addStatWithMultiplyInfo("Accuracy", "", 1.0f / (this.modifyStatFromModules(10, weapon, 1.0f) * this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_MULTIPLY_TAG, 1.0f)), ""));
        String heatInfo = EnumChatFormatting.DARK_RED + "Heat: ";
        double heatPercent = this.getHeat(weapon) / this.getMaxHeat(weapon);
        int i = 0;
        while ((double)i < 32.0 * heatPercent) {
            heatInfo = heatInfo + "|";
            ++i;
        }
        infos.add(heatInfo);
        infos.add("");
        this.addCustomDetails(weapon, player, infos);
        this.AddModuleDetails(weapon, infos);
    }

    private String addStatWithMultiplyInfo(String statName, Object value, double multiply, String units) {
        String info = String.format("%s: %s%s", statName, EnumChatFormatting.DARK_AQUA, value);
        if (!units.isEmpty()) {
            info = info + " " + units;
        }
        if (multiply != 1.0) {
            info = multiply > 1.0 ? info + EnumChatFormatting.DARK_GREEN : info + EnumChatFormatting.DARK_RED;
            info = info + String.format(" (%s) %s", DecimalFormat.getPercentInstance().format(multiply), EnumChatFormatting.RESET);
        }
        return info;
    }

    private void AddModuleDetails(ItemStack weapon, List infos) {
        ItemStack module = WeaponHelper.getModuleAtSlot(2, weapon);
        if (module != null) {
            // empty if block
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void manageClientServerTicks(World world) {
        ClientProxy.instance().getClientWeaponHandler().sendWeaponTickToServer(world, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void sendShootTickToServer(World world, WeaponShot weaponShot, Vec3 dir, Vec3 pos) {
        PacketFirePlasmaShot packetFirePlasmaShot = new PacketFirePlasmaShot(Minecraft.func_71410_x().field_71439_g.func_145782_y(), pos, dir, weaponShot);
        ClientProxy.instance().getClientWeaponHandler().sendWeaponTickToServer(world, packetFirePlasmaShot);
    }

    @SideOnly(value=Side.CLIENT)
    public void addShootDelay(ItemStack weaponStack) {
        ClientProxy.instance().getClientWeaponHandler().addShootDelay(this, weaponStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasShootDelayPassed() {
        return ClientProxy.instance().getClientWeaponHandler().shootDelayPassed(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack weapon, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (sendServerTick) {
            this.manageClientServerTicks(world);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onLeftClick(ItemStack weapon, EntityPlayer entityPlayer) {
        return this.leftClickFire;
    }

    public void chargeFromEnergyPack(ItemStack weapon, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (player.field_71071_by.field_70462_a[i] == null || !(player.field_71071_by.field_70462_a[i].func_77973_b() instanceof IEnergyPack) || player.field_71071_by.field_70462_a[i].field_77994_a <= 0) continue;
                --player.field_71071_by.field_70462_a[i].field_77994_a;
                this.setEnergyStored(weapon, Math.min(this.getEnergyStored(weapon) + ((IEnergyPack)player.field_71071_by.field_70462_a[i].func_77973_b()).getEnergyAmount(player.field_71071_by.field_70462_a[i]), this.getMaxEnergyStored(weapon)));
                player.field_71071_by.field_70459_e = true;
                player.field_70170_p.func_72956_a((Entity)player, "mo:reload", 0.7f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
                if (player.field_71071_by.field_70462_a[i].field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[i] = null;
                }
                return;
            }
        } else {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyPack) || stack.field_77994_a <= 0) continue;
                ClientProxy.instance().getClientWeaponHandler().addReloadDelay(this, 40);
                MatterOverdrive.packetPipeline.sendToServer(new PacketReloadEnergyWeapon());
                return;
            }
        }
    }

    protected void manageOverheat(ItemStack itemStack, World world, EntityLivingBase shooter) {
        if (this.getHeat(itemStack) >= this.getMaxHeat(itemStack) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventEnergyWeapon.Overheat(itemStack, shooter))) {
            this.setOverheated(itemStack, true);
            world.func_72956_a((Entity)shooter, "mo:overheat", 1.0f, 1.0f);
            world.func_72956_a((Entity)shooter, "mo:overheat_alarm", 1.0f, 1.0f);
        }
    }

    protected void manageCooling(ItemStack itemStack) {
        float heat = this.getHeat(itemStack);
        if (heat > 0.0f) {
            float easing = MOEasing.Quart.easeOut(heat / this.getMaxHeat(itemStack), 0.0f, 4.0f, 1.0f);
            float newHeat = heat - easing;
            if (newHeat < 0.001f) {
                newHeat = 0.0f;
            }
            this.setHeat(itemStack, Math.max(0.0f, newHeat));
        }
        if (this.isOverheated(itemStack) && this.getHeat(itemStack) < 2.0f) {
            this.setOverheated(itemStack, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void addCustomDetails(ItemStack var1, EntityPlayer var2, List var3);

    protected abstract int getBaseEnergyUse(ItemStack var1);

    protected abstract int getBaseMaxHeat(ItemStack var1);

    public abstract float getWeaponBaseDamage(ItemStack var1);

    public abstract float getWeaponBaseAccuracy(ItemStack var1, boolean var2);

    public abstract boolean canFire(ItemStack var1, World var2, EntityLivingBase var3);

    public abstract float getShotSpeed(ItemStack var1, EntityLivingBase var2);

    public abstract int getBaseShootCooldown(ItemStack var1);

    public abstract float getBaseZoom(ItemStack var1, EntityLivingBase var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void onClientShot(ItemStack var1, EntityLivingBase var2, Vec3 var3, Vec3 var4, WeaponShot var5);

    @SideOnly(value=Side.CLIENT)
    public abstract void onProjectileHit(MovingObjectPosition var1, ItemStack var2, World var3, float var4);

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && MOEnergyHelper.isEnergyContainerItem(energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            int energy = e.receiveEnergy(energy_module, maxReceive, simulate);
            if (!simulate) {
                WeaponHelper.setModuleAtSlot(0, container, energy_module);
            }
            return energy;
        }
        return super.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    public int extractEnergyCustom(ItemStack weapon, int maxExtract, boolean simulate) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, weapon);
        if (energy_module != null && MOEnergyHelper.isEnergyContainerItem(energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            int energy = e.extractEnergy(energy_module, this.maxReceive, simulate);
            if (!simulate) {
                WeaponHelper.setModuleAtSlot(0, weapon, energy_module);
            }
            return energy;
        }
        return super.extractEnergy(weapon, this.maxReceive, simulate);
    }

    @Override
    protected void setEnergyStored(ItemStack container, int amount) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && MOEnergyHelper.isEnergyContainerItem(energy_module)) {
            MOEnergyHelper.setDefaultEnergyTag(energy_module, amount);
            WeaponHelper.setModuleAtSlot(0, container, energy_module);
        } else {
            super.setEnergyStored(container, amount);
        }
    }

    public void rechargeFully(ItemStack container) {
        this.setEnergyStored(container, this.getMaxEnergyStored(container));
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && MOEnergyHelper.isEnergyContainerItem(energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            return e.getEnergyStored(energy_module);
        }
        return super.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        ItemStack energy_module = WeaponHelper.getModuleAtSlot(0, container);
        if (energy_module != null && MOEnergyHelper.isEnergyContainerItem(energy_module)) {
            IEnergyContainerItem e = (IEnergyContainerItem)energy_module.func_77973_b();
            return e.getMaxEnergyStored(energy_module);
        }
        return this.capacity;
    }

    protected boolean DrainEnergy(ItemStack item, float ticks, boolean simulate) {
        int amount;
        int hasEnergy = this.getEnergyStored(item);
        if (hasEnergy >= amount) {
            for (amount = (int)((float)this.getEnergyUse(item) * ticks); amount > 0; amount -= this.extractEnergyCustom(item, amount, simulate)) {
                if (this.extractEnergyCustom(item, amount, true) > 0) {
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getRange(ItemStack weapon) {
        int range = this.defaultRange;
        range = Math.round(this.modifyStatFromModules(3, weapon, range));
        return range *= this.getCustomIntStat(weapon, CUSTOM_RANGE_MULTIPLY_TAG, 1);
    }

    @Override
    public int getShootCooldown(ItemStack weapon) {
        int shootCooldown = this.getCustomIntStat(weapon, CUSTOM_SPEED_TAG, this.getBaseShootCooldown(weapon));
        shootCooldown = (int)this.modifyStatFromModules(7, weapon, shootCooldown);
        shootCooldown = (int)((float)shootCooldown * this.getCustomFloatStat(weapon, CUSTOM_SPEED_MULTIPLY_TAG, 1.0f));
        return shootCooldown;
    }

    public WeaponShot createShot(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        return new WeaponShot(field_77697_d.nextInt(), this.getWeaponScaledDamage(weapon, shooter), this.getAccuracy(weapon, shooter, zoomed), WeaponHelper.getColor(weapon), this.getRange(weapon));
    }

    public float modifyStatFromModules(int statID, ItemStack weapon, float original) {
        return WeaponHelper.modifyStat(statID, weapon, original);
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        return true;
    }

    public float getWeaponScaledDamage(ItemStack weapon, EntityLivingBase shooter) {
        float damage = this.getCustomFloatStat(weapon, CUSTOM_DAMAGE_TAG, this.getWeaponBaseDamage(weapon));
        damage = this.modifyStatFromModules(0, weapon, damage);
        damage += damage * (float)EnchantmentHelper.func_77506_a((int)MatterOverdriveEnchantments.overclock.field_77352_x, (ItemStack)weapon) * 0.04f;
        damage *= this.getCustomFloatStat(weapon, CUSTOM_DAMAGE_MULTIPLY_TAG, 1.0f);
        damage = (float)((double)damage + shooter.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        return damage;
    }

    public DamageSource getDamageSource(ItemStack weapon, EntityPlayer player) {
        EntityDamageSourcePhaser damageInfo = new EntityDamageSourcePhaser((Entity)player);
        if (WeaponHelper.hasStat(4, weapon)) {
            damageInfo.func_76361_j();
        } else if (WeaponHelper.hasStat(8, weapon)) {
            damageInfo.func_82726_p();
        }
        if (WeaponHelper.hasStat(6, weapon)) {
            damageInfo.func_94540_d();
        }
        return damageInfo;
    }

    public int getEnergyUse(ItemStack weapon) {
        float energyUse = this.modifyStatFromModules(1, weapon, this.getBaseEnergyUse(weapon));
        energyUse -= energyUse * (float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)weapon) * 0.04f;
        return Math.max((int)energyUse, 0);
    }

    public void addHeat(ItemStack itemStack, int amount) {
        if (itemStack.func_77942_o()) {
            this.setHeat(itemStack, this.getHeat(itemStack) + (float)amount);
        }
    }

    public void setHeat(ItemStack item, float amount) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74776_a("heat", Math.min(amount, this.getMaxHeat(item) + 1.0f));
        }
    }

    @Override
    public float getHeat(ItemStack item) {
        if (item.func_77942_o()) {
            return item.func_77978_p().func_74760_g("heat");
        }
        return 0.0f;
    }

    @Override
    public float getMaxHeat(ItemStack weapon) {
        return this.modifyStatFromModules(9, weapon, this.getBaseMaxHeat(weapon));
    }

    public boolean isOverheated(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            return weapon.func_77978_p().func_74767_n("Overheated");
        }
        return false;
    }

    protected void setOverheated(ItemStack weapon, boolean overheated) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_74757_a("Overheated", overheated);
        }
    }

    @Override
    public int getAmmo(ItemStack weapon) {
        return this.getEnergyStored(weapon);
    }

    @Override
    public float getAccuracy(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        ItemStack sights;
        float accuracy = this.getWeaponBaseAccuracy(weapon, zoomed);
        accuracy = this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_TAG, accuracy);
        accuracy += (float)Vec3.func_72443_a((double)shooter.field_70159_w, (double)(shooter.field_70181_x * 0.1), (double)shooter.field_70179_y).func_72433_c() * 10.0f;
        accuracy *= shooter.func_70093_af() ? 0.6f : 1.0f;
        accuracy = this.modifyStatFromModules(10, weapon, accuracy);
        if (WeaponHelper.hasModule(3, weapon) && (sights = WeaponHelper.getModuleAtSlot(3, weapon)).func_77973_b() instanceof IWeaponScope) {
            accuracy = ((IWeaponScope)sights.func_77973_b()).getAccuracyModify(sights, weapon, zoomed, accuracy);
        }
        return accuracy *= this.getCustomFloatStat(weapon, CUSTOM_ACCURACY_MULTIPLY_TAG, 1.0f);
    }

    public void removeAllCustomStats(ItemStack weapon) {
        if (weapon.func_77942_o()) {
            weapon.func_77978_p().func_82580_o(CUSTOM_DAMAGE_TAG);
            weapon.func_77978_p().func_82580_o(CUSTOM_ACCURACY_TAG);
        }
    }

    public float getCustomFloatStat(ItemStack weapon, String name, float def) {
        if (weapon.func_77942_o() && weapon.func_77978_p().func_150297_b(name, 5)) {
            return weapon.func_77978_p().func_74760_g(name);
        }
        return def;
    }

    public int getCustomIntStat(ItemStack weapon, String name, int def) {
        if (weapon.func_77942_o() && weapon.func_77978_p().func_150297_b(name, 3)) {
            return weapon.func_77978_p().func_74762_e(name);
        }
        return def;
    }

    @Override
    public int getMaxAmmo(ItemStack weapon) {
        return this.getMaxEnergyStored(weapon);
    }

    public boolean needsRecharge(ItemStack weapon) {
        return !this.DrainEnergy(weapon, this.getShootCooldown(weapon), true);
    }

    public int func_77619_b() {
        return Item.ToolMaterial.IRON.func_77995_e();
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    @Override
    public float getZoomMultiply(EntityPlayer entityPlayer, ItemStack weapon) {
        ItemStack sights;
        if (WeaponHelper.hasModule(3, weapon) && (sights = WeaponHelper.getModuleAtSlot(3, weapon)).func_77973_b() instanceof IWeaponScope) {
            return ((IWeaponScope)sights.func_77973_b()).getZoomAmount(sights, weapon);
        }
        return this.getBaseZoom(weapon, (EntityLivingBase)entityPlayer);
    }
}

