/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class IonSniper
extends EnergyWeapon {
    private static final int MAX_HEAT = 100;
    private static final int MAX_USE_TIME = 512;
    private static final int ENERGY_PER_SHOT = 3072;
    public static final int RANGE = 96;

    public IonSniper(String name) {
        super(name, 32000, 128, 128, 96);
        this.func_77664_n();
        this.leftClickFire = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        return 3072 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 100;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 21.0f;
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        if (zoomed) {
            return 1.0f + this.getHeat(weapon) * 0.1f;
        }
        return 5.0f + this.getHeat(weapon) * 0.3f;
    }

    @Override
    public boolean canFire(ItemStack weapon, World world, EntityLivingBase shooter) {
        return this.DrainEnergy(weapon, this.getShootCooldown(weapon), true) && !this.isOverheated(weapon);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 8.0f;
    }

    @Override
    public int getBaseShootCooldown(ItemStack weapon) {
        return 30;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.4f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    if (this.isWeaponZoomed(entityPlayer, itemStack)) {
                        ClientWeaponHandler.RECOIL_AMOUNT = 2.0f + Math.min(2.0f, this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, true));
                        Minecraft.func_71410_x().field_71451_h.field_70737_aN = 30 + (int)(this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 8.0f);
                        Minecraft.func_71410_x().field_71451_h.field_70738_aO = 45;
                    } else {
                        ClientWeaponHandler.RECOIL_AMOUNT = 4.0f + Math.min(2.0f, this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, true));
                        Minecraft.func_71410_x().field_71451_h.field_70737_aN = 30 + (int)(this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 8.0f);
                        Minecraft.func_71410_x().field_71451_h.field_70738_aO = 45;
                    }
                    ClientWeaponHandler.RECOIL_TIME = 1.0f;
                }
                Vec3 dir = entityPlayer.func_70676_i(1.0f);
                Vec3 pos = this.getFirePosition(entityPlayer, dir, this.isWeaponZoomed(entityPlayer, itemStack));
                WeaponShot shot = this.createShot(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed(entityPlayer, itemStack));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3 getFirePosition(EntityPlayer entityPlayer, Vec3 dir, boolean isAiming) {
        Vec3 pos = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v);
        if (!isAiming) {
            pos.field_72450_a -= (double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            pos.field_72449_c -= (double)(MathHelper.func_76126_a((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(new ResourceLocation("mo:sniper_rifle_fire"), 3.0f + field_77697_d.nextFloat() * 0.5f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        this.spawnProjectile(weapon, shooter, position, dir, shot);
    }

    @Override
    public void onProjectileHit(MovingObjectPosition hit, ItemStack weapon, World world, float amount) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 4: {
                return new Vector2f(205.0f, 80.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 35.0f);
            }
        }
        return new Vector2f(0.0f, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 80.0f);
            }
            case 1: {
                return new Vector2f(110.0f, 90.0f);
            }
            case 2: {
                return new Vector2f(90.0f, 95.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 72.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    public PlasmaBolt spawnProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        PlasmaBolt fire = new PlasmaBolt(shooter.field_70170_p, shooter, position, dir, shot, this.getShotSpeed(weapon, shooter));
        fire.setWeapon(weapon);
        fire.setFireDamageMultiply(WeaponHelper.modifyStat(4, weapon, 0.0f));
        fire.setKnockBack(1.0f);
        shooter.field_70170_p.func_72838_d((Entity)fire);
        return fire;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemStack) {
        return itemStack.func_77960_j() == 1 ? EnumAction.bow : EnumAction.none;
    }

    public int func_77626_a(ItemStack item) {
        return 512;
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        player.func_71008_a(item, Integer.MAX_VALUE);
        if (world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return item;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        if (module != null && module.func_77973_b() instanceof IWeaponModule && ((IWeaponModule)module.func_77973_b()).getSlot(module) == 2) {
            return module.func_77960_j() != 2 && module.func_77960_j() != 3;
        }
        return true;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3 position, Vec3 dir, int delay) {
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        float newHeat = this.getHeat(weapon) + this.getMaxHeat(weapon) * 0.8f;
        this.setHeat(weapon, newHeat);
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        PlasmaBolt fire = this.spawnProjectile(weapon, shooter, position, dir, shot);
        fire.simulateDelay(delay);
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityPlayer entityPlayer, ItemStack weapon) {
        return Mouse.isButtonDown((int)1) && entityPlayer.func_71039_bw();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return null;
    }
}

