/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.fx.PhaserBoltRecoil;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.server.PacketDigBlock;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class OmniTool
extends EnergyWeapon {
    private static float BLOCK_DAMAGE;
    private static float STEP_SOUND_COUNTER;
    private static float LAST_BRAKE_TIME;
    private static int CURRENT_BLOCK_X;
    private static int CURRENT_BLOCK_Y;
    private static int CURRENT_BLOCK_Z;
    private static int LAST_SIDE;
    public static final int RANGE = 24;
    private static final int MAX_USE_TIME = 240;
    private static final int ENERGY_PER_SHOT = 512;
    private static final float DIG_POWER_MULTIPLY = 0.007f;

    public OmniTool(String name) {
        super(name, 32000, 128, 128, 24);
        this.setHarvestLevel("pickaxe", 3);
        this.setHarvestLevel("axe", 3);
        this.field_77789_bW = true;
        this.leftClickFire = true;
    }

    public int func_77626_a(ItemStack item) {
        return 240;
    }

    @Override
    public int func_77619_b() {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        this.TagCompountCheck(item);
        if (this.canDig(item, world)) {
            player.func_71008_a(item, this.func_77626_a(item));
            if (world.field_72995_K) {
                this.stopMiningLastBlock();
            }
        }
        if (this.needsRecharge(item)) {
            this.chargeFromEnergyPack(item, player);
        }
        return item;
    }

    public void onUsingTick(ItemStack itemStack, EntityPlayer player, int count) {
        if (player.field_70170_p.field_72995_K && player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            MovingObjectPosition movingObjectPosition;
            if (this.canDig(itemStack, player.field_70170_p) && (movingObjectPosition = player.func_70614_a((double)this.getRange(itemStack), 1.0f)) != null && movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                boolean canMine;
                int x = movingObjectPosition.field_72311_b;
                int y = movingObjectPosition.field_72312_c;
                int z = movingObjectPosition.field_72309_d;
                Block block = player.field_70170_p.func_147439_a(x, y, z);
                boolean bl = canMine = player.field_70170_p.func_72962_a(player, x, y, z) && player.func_82246_f(x, y, z);
                if (block != null && block.func_149688_o() != Material.field_151579_a && canMine) {
                    float percent = 1.0f - (float)count / (float)this.func_77626_a(itemStack);
                    STEP_SOUND_COUNTER += 1.0f;
                    LAST_SIDE = movingObjectPosition.field_72310_e;
                    if (this.isSameBlock(x, y, z)) {
                        if (BLOCK_DAMAGE >= 1.0f) {
                            MatterOverdrive.packetPipeline.sendToServer(new PacketDigBlock(x, y, z, 2, movingObjectPosition.field_72310_e));
                            Minecraft.func_71410_x().field_71442_b.func_78751_a(x, y, z, movingObjectPosition.field_72310_e);
                            BLOCK_DAMAGE = 0.0f;
                            STEP_SOUND_COUNTER = 0.0f;
                        } else if (BLOCK_DAMAGE == 0.0f) {
                            MatterOverdrive.packetPipeline.sendToServer(new PacketDigBlock(x, y, z, 0, movingObjectPosition.field_72310_e));
                        }
                        BLOCK_DAMAGE = MathHelper.func_76131_a((float)this.modifyStatFromModules(0, itemStack, BLOCK_DAMAGE + block.func_149737_a(player, player.field_70170_p, x, y, z)), (float)0.0f, (float)1.0f);
                        player.field_70170_p.func_147443_d(player.func_145782_y(), x, y, z, (int)(BLOCK_DAMAGE * 10.0f));
                    } else {
                        this.stopMiningLastBlock();
                        this.setLastBlock(x, y, z);
                    }
                }
            }
        } else {
            this.DrainEnergy(itemStack, 0.007f, false);
        }
    }

    boolean isSameBlock(int x, int y, int z) {
        return x == CURRENT_BLOCK_X && y == CURRENT_BLOCK_Y && z == CURRENT_BLOCK_Z;
    }

    @SideOnly(value=Side.CLIENT)
    void setLastBlock(int x, int y, int z) {
        CURRENT_BLOCK_X = x;
        CURRENT_BLOCK_Y = y;
        CURRENT_BLOCK_Z = z;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer entityPlayer, int count) {
        super.func_77615_a(itemStack, world, entityPlayer, count);
        if (world.field_72995_K) {
            this.stopMiningLastBlock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopMiningLastBlock() {
        BLOCK_DAMAGE = 0.0f;
        STEP_SOUND_COUNTER = 0.0f;
        MatterOverdrive.packetPipeline.sendToServer(new PacketDigBlock(CURRENT_BLOCK_X, CURRENT_BLOCK_Y, CURRENT_BLOCK_Z, 1, LAST_SIDE));
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return false;
    }

    public PlasmaBolt spawnProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        PlasmaBolt fire = new PlasmaBolt(shooter.field_70170_p, shooter, position, dir, shot, this.getShotSpeed(weapon, shooter));
        fire.setWeapon(weapon);
        fire.setFireDamageMultiply(WeaponHelper.modifyStat(4, weapon, 0.0f));
        fire.setKnockBack(0.05f);
        shooter.field_70170_p.func_72838_d((Entity)fire);
        return fire;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(new ResourceLocation("mo:laser_fire_0"), 0.5f + field_77697_d.nextFloat() * 0.2f, 1.2f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        this.spawnProjectile(weapon, shooter, position, dir, shot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onProjectileHit(MovingObjectPosition hit, ItemStack weapon, World world, float amount) {
        if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && amount == 1.0f && field_77697_d.nextFloat() < 0.8f) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new PhaserBoltRecoil(world, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, new Color(255, 255, 255)));
        }
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        return 0.3f + this.getHeat(weapon) / this.getMaxHeat(weapon) * 5.0f;
    }

    public float func_150893_a(ItemStack p_150893_1_, Block p_150893_2_) {
        return 8.0f;
    }

    public boolean func_150897_b(Block p_150897_1_) {
        return true;
    }

    private boolean sameToolAndBlock(int x, int y, int z) {
        return x == CURRENT_BLOCK_X && y == CURRENT_BLOCK_Y && z == CURRENT_BLOCK_Z;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    protected int getBaseEnergyUse(ItemStack item) {
        return 512 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 7.0f;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world, EntityLivingBase shooter) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, this.getShootCooldown(itemStack), true);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 3.0f;
    }

    public boolean canDig(ItemStack itemStack, World world) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, 0.007f, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(80.0f, 40.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 4: {
                return new Vector2f(200.0f, 45.0f);
            }
        }
        return new Vector2f(0.0f, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(173.0f, 90.0f);
            }
            case 1: {
                return new Vector2f(125.0f, 72.0f);
            }
            case 2: {
                return new Vector2f(85.0f, 105.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return slot != 3;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        if (module != null) {
            return module.func_77973_b() == MatterOverdriveItems.weapon_module_color || module.func_77973_b() == MatterOverdriveItems.weapon_module_barrel && module.func_77960_j() != 2 && module.func_77960_j() != 3;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                itemStack.func_77978_p().func_74772_a("LastShot", world.func_82737_E());
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    ClientWeaponHandler.RECOIL_AMOUNT = 6.0f + this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed(entityPlayer, itemStack)) * 2.0f;
                    ClientWeaponHandler.RECOIL_TIME = 1.0f;
                    Minecraft.func_71410_x().field_71451_h.field_70737_aN = 8;
                    Minecraft.func_71410_x().field_71451_h.field_70738_aO = 20;
                }
                Vec3 dir = entityPlayer.func_70676_i(1.0f);
                Vec3 pos = this.getFirePosition(entityPlayer, dir, Mouse.isButtonDown((int)1));
                WeaponShot shot = this.createShot(itemStack, (EntityLivingBase)entityPlayer, Mouse.isButtonDown((int)1));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3 getFirePosition(EntityPlayer entityPlayer, Vec3 dir, boolean isAiming) {
        Vec3 pos = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v);
        if (!isAiming) {
            pos.field_72450_a -= (double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            pos.field_72449_c -= (double)(MathHelper.func_76126_a((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            pos.field_72448_b -= (double)(MathHelper.func_76134_b((float)(entityPlayer.field_70125_A / 180.0f * (float)Math.PI)) * 0.16f);
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3 position, Vec3 dir, int delay) {
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        float newHeat = (this.getHeat(weapon) + 4.0f) * 2.7f;
        this.setHeat(weapon, newHeat);
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        PlasmaBolt fire = this.spawnProjectile(weapon, shooter, position, dir, shot);
        fire.simulateDelay(delay);
        weapon.func_77978_p().func_74772_a("LastShot", shooter.field_70170_p.func_82737_E());
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    public int getBaseShootCooldown(ItemStack itemStack) {
        return 18;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityPlayer entityPlayer, ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return new WeaponSound(new ResourceLocation("mo:omni_tool_hum"), (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, field_77697_d.nextFloat() * 0.04f + 0.06f, field_77697_d.nextFloat() * 0.1f + 0.95f);
    }
}

