/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class PlasmaShotgun
extends EnergyWeapon {
    private static final int MAX_CHARGE_TIME = 20;
    private static final int ENERGY_PER_SHOT = 2560;
    public static final int RANGE = 16;
    @SideOnly(value=Side.CLIENT)
    private MOPositionedSound lastChargingSound;

    public PlasmaShotgun(String name) {
        super(name, 32000, 128, 128, 16);
        this.func_77664_n();
        this.leftClickFire = true;
    }

    @Override
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        return 2560 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 16.0f;
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        return 5.0f + this.getHeat(weapon) * 0.3f;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world, EntityLivingBase shooter) {
        return this.DrainEnergy(itemStack, this.getShootCooldown(itemStack), true) && !this.isOverheated(itemStack);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 3.0f;
    }

    @Override
    public int getBaseShootCooldown(ItemStack weapon) {
        return 22;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(new ResourceLocation("mo:plasma_shotgun_shot"), 0.3f + field_77697_d.nextFloat() * 0.2f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)sound, 1);
        this.spawnProjectile(weapon, shooter, position, dir, shot);
    }

    public PlasmaBolt[] spawnProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3 position, Vec3 dir, WeaponShot shot) {
        PlasmaBolt[] bolts = new PlasmaBolt[shot.getCount()];
        for (int i = 0; i < shot.getCount(); ++i) {
            WeaponShot newShot = new WeaponShot(shot);
            newShot.setSeed(shot.getSeed() + i);
            newShot.setDamage(shot.getDamage() / (float)shot.getCount());
            bolts[i] = new PlasmaBolt(shooter.field_70170_p, shooter, position, dir, newShot, this.getShotSpeed(weapon, shooter));
            bolts[i].setWeapon(weapon);
            bolts[i].setRenderSize((float)(this.getShotCount(weapon, shooter) / shot.getCount()) * 0.5f);
            bolts[i].setFireDamageMultiply(WeaponHelper.modifyStat(4, weapon, 0.0f));
            bolts[i].setKnockBack(0.5f);
            shooter.field_70170_p.func_72838_d((Entity)bolts[i]);
        }
        return bolts;
    }

    public int getShotCount(ItemStack weapon, EntityLivingBase shooter) {
        return 10;
    }

    @Override
    public void onProjectileHit(MovingObjectPosition hit, ItemStack weapon, World world, float amount) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 4: {
                return new Vector2f(205.0f, 80.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 35.0f);
            }
        }
        return new Vector2f(0.0f, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 80.0f);
            }
            case 1: {
                return new Vector2f(100.0f, 80.0f);
            }
            case 2: {
                return new Vector2f(90.0f, 90.0f);
            }
            case 3: {
                return new Vector2f(140.0f, 72.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return true;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        if (module != null) {
            return module.func_77973_b() == MatterOverdriveItems.weapon_module_color || module.func_77973_b() == MatterOverdriveItems.weapon_module_barrel && module.func_77960_j() != 2 && module.func_77960_j() != 3;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack weapon, World world, EntityPlayer entityPlayer) {
        if (world.field_72995_K && this.canFire(weapon, world, (EntityLivingBase)entityPlayer) && this.hasShootDelayPassed() && !entityPlayer.func_71039_bw()) {
            entityPlayer.func_71008_a(weapon, this.func_77626_a(weapon));
            this.playChargingSound(entityPlayer);
        }
        return weapon;
    }

    @SideOnly(value=Side.CLIENT)
    public void playChargingSound(EntityPlayer entityPlayer) {
        this.lastChargingSound = new MOPositionedSound(new ResourceLocation("mo:plasma_shotgun_charging"), 3.0f + field_77697_d.nextFloat() * 0.2f, 0.9f * field_77697_d.nextFloat() * 0.2f);
        this.lastChargingSound.setPosition((float)entityPlayer.field_70165_t, (float)entityPlayer.field_70163_u, (float)entityPlayer.field_70161_v);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.lastChargingSound);
    }

    @SideOnly(value=Side.CLIENT)
    public void stopChargingSound() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.lastChargingSound);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
    }

    public void func_77615_a(ItemStack weapon, World world, EntityPlayer entityPlayer, int time) {
        if (world.field_72995_K) {
            int maxCount = this.getShotCount(weapon, (EntityLivingBase)entityPlayer);
            int timeElapsed = this.func_77626_a(weapon) - time;
            int count = Math.max(1, (int)((1.0f - (float)timeElapsed / 20.0f) * (float)maxCount));
            float shotPercent = (float)count / (float)this.getShotCount(weapon, (EntityLivingBase)entityPlayer);
            ClientWeaponHandler.RECOIL_AMOUNT = (float)(15 + (maxCount - count) * 2) + this.getAccuracy(weapon, (EntityLivingBase)entityPlayer, this.isWeaponZoomed(entityPlayer, weapon)) * 2.0f;
            ClientWeaponHandler.RECOIL_TIME = 1.0f + (float)(maxCount - count) * 0.03f;
            Minecraft.func_71410_x().field_71451_h.field_70737_aN = 15 + (maxCount - count);
            Minecraft.func_71410_x().field_71451_h.field_70738_aO = 30 + (maxCount - count);
            Vec3 dir = entityPlayer.func_70676_i(1.0f);
            Vec3 pos = this.getFirePosition(entityPlayer, dir, Mouse.isButtonDown((int)1));
            WeaponShot shot = this.createShot(weapon, (EntityLivingBase)entityPlayer, Mouse.isButtonDown((int)1));
            shot.setCount(count);
            shot.setAccuracy(shot.getAccuracy() * shotPercent);
            shot.setRange(shot.getRange() + (int)((float)shot.getRange() * (1.0f - shotPercent)));
            this.onClientShot(weapon, (EntityLivingBase)entityPlayer, pos, dir, shot);
            MatterOverdrive.packetPipeline.sendToServer(new PacketFirePlasmaShot(entityPlayer.func_145782_y(), pos, dir, shot));
            this.addShootDelay(weapon);
            this.stopChargingSound();
            entityPlayer.func_71041_bz();
        }
    }

    public ItemStack func_77654_b(ItemStack weapon, World world, EntityPlayer entityPlayer) {
        return weapon;
    }

    public int func_77626_a(ItemStack weapon) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3 getFirePosition(EntityPlayer entityPlayer, Vec3 dir, boolean isAiming) {
        Vec3 pos = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v);
        if (!isAiming) {
            // empty if block
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                itemStack.func_77978_p().func_74772_a("LastShot", world.func_82737_E());
                ClientWeaponHandler.RECOIL_AMOUNT = 12.0f + this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed(entityPlayer, itemStack)) * 2.0f;
                ClientWeaponHandler.RECOIL_TIME = 1.0f;
                Minecraft.func_71410_x().field_71451_h.field_70737_aN = 15;
                Minecraft.func_71410_x().field_71451_h.field_70738_aO = 30;
                Vec3 dir = entityPlayer.func_70676_i(1.0f);
                Vec3 pos = this.getFirePosition(entityPlayer, dir, Mouse.isButtonDown((int)1));
                WeaponShot shot = this.createShot(itemStack, (EntityLivingBase)entityPlayer, Mouse.isButtonDown((int)1));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    @Override
    public WeaponShot createShot(ItemStack weapon, EntityLivingBase shooter, boolean zoomed) {
        WeaponShot shot = new WeaponShot(field_77697_d.nextInt(), this.getWeaponScaledDamage(weapon, shooter), this.getAccuracy(weapon, shooter, zoomed), WeaponHelper.getColor(weapon), this.getRange(weapon));
        shot.setCount(this.getShotCount(weapon, shooter));
        return shot;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3 position, Vec3 dir, int delay) {
        PlasmaBolt[] fires;
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        int heatAdd = (this.getShotCount(weapon, shooter) - shot.getCount()) * 2;
        float newHeat = (this.getHeat(weapon) + (float)heatAdd + 6.0f) * 4.2f;
        this.setHeat(weapon, Math.max(newHeat, 0.0f));
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        for (PlasmaBolt bolt : fires = this.spawnProjectile(weapon, shooter, position, dir, shot)) {
            bolt.simulateDelay(delay);
        }
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityPlayer entityPlayer, ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return null;
    }
}

