/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.components;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.network.IMatterNetworkFilter;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DestinationFilterSlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ComponentMatterNetworkConfigs
extends MachineComponentAbstract<MOTileEntityMachine> {
    private String destinationFilter;
    private int destinationFilterSlot;

    public ComponentMatterNetworkConfigs(MOTileEntityMachine machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS) && nbt.func_150297_b("DestinationFilter", 8)) {
            this.destinationFilter = nbt.func_74779_i("DestinationFilter");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.CONFIGS) && this.destinationFilter != null) {
            nbt.func_74778_a("DestinationFilter", this.destinationFilter);
        }
    }

    @Override
    public void registerSlots(Inventory inventory) {
        this.destinationFilterSlot = inventory.AddSlot(new DestinationFilterSlot(false));
    }

    @Override
    public void update(MOTileEntityMachine machine) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onActiveChange(MOTileEntityMachine machine) {
    }

    @Override
    public void onAwake(MOTileEntityMachine machine, Side side) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving, MOTileEntityMachine machine) {
    }

    public NBTTagCompound getFilter() {
        if (this.machine.func_70301_a(this.destinationFilterSlot) != null && this.machine.func_70301_a(this.destinationFilterSlot).func_77973_b() instanceof IMatterNetworkFilter) {
            return ((IMatterNetworkFilter)this.machine.func_70301_a(this.destinationFilterSlot).func_77973_b()).getFilter(this.machine.func_70301_a(this.destinationFilterSlot));
        }
        return null;
    }

    public int getDestinationFilterSlot() {
        return this.destinationFilterSlot;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }
}

