/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.transporter.components;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.transport.TransportLocation;
import matteroverdrive.data.Inventory;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.configs.IConfigProperty;
import matteroverdrive.machines.transporter.TileEntityMachineTransporter;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral")})
public class ComponentComputers
extends MachineComponentAbstract<TileEntityMachineTransporter>
implements IPeripheral {
    private static String[] methodNames = new String[]{"getLocations", "getSelectedLocation", "getLocation", "addLocation", "setSelectedLocation", "setName", "setX", "setY", "setZ", "setRedstoneMode"};
    private String peripheralName = "mo_transporter";

    public ComponentComputers(TileEntityMachineTransporter machine) {
        super(machine);
    }

    private Object[] callMethod(int method, Object[] args) {
        switch (method) {
            case 0: {
                return this.computerGetLocations(args);
            }
            case 1: {
                return this.computerGetSelectedLocation(args);
            }
            case 2: {
                return this.computerGetLocation(args);
            }
            case 3: {
                return this.computerAddLocation(args);
            }
            case 4: {
                return this.computerSetSelectedLocation(args);
            }
            case 5: {
                return this.computerSetName(args);
            }
            case 6: {
                return this.computerSetX(args);
            }
            case 7: {
                return this.computerSetY(args);
            }
            case 8: {
                return this.computerSetZ(args);
            }
            case 9: {
                return this.computerSetRedstoneMode(args);
            }
        }
        throw new IllegalArgumentException("Invalid method id");
    }

    private Object[] computerGetLocations(Object[] args) {
        ArrayList list = new ArrayList();
        for (TransportLocation loc : ((TileEntityMachineTransporter)this.machine).getPositions()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", loc.name);
            map.put("selected", ((TileEntityMachineTransporter)this.machine).selectedLocation == ((TileEntityMachineTransporter)this.machine).getPositions().indexOf(loc));
            map.put("x", loc.x);
            map.put("y", loc.y);
            map.put("z", loc.z);
            list.add(map);
        }
        return list.toArray();
    }

    private Object[] computerGetSelectedLocation(Object[] args) {
        return this.computerGetLocation(new Object[]{1.0});
    }

    private Object[] computerGetLocation(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("First argument must be the numerical id of the transport location");
        }
        int locNum = (int)Math.floor((Double)args[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        TransportLocation loc = ((TileEntityMachineTransporter)this.machine).getPositions().get(locNum);
        map.put("name", loc.name);
        map.put("x", loc.x);
        map.put("y", loc.y);
        map.put("z", loc.z);
        return new Object[]{map};
    }

    private Object[] computerAddLocation(Object[] args) {
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException("First argument must be a string containing the name of the transport location");
        }
        for (int i = 1; i <= 4; ++i) {
            if (args[i] instanceof Double) continue;
            throw new IllegalArgumentException("Argument " + i + 1 + " must be an integer");
        }
        String name = (String)args[0];
        int x = (int)Math.floor((Double)args[1]);
        int y = (int)Math.floor((Double)args[2]);
        int z = (int)Math.floor((Double)args[3]);
        ((TileEntityMachineTransporter)this.machine).addNewLocation(x, y, z, name);
        return null;
    }

    private Object[] computerSetSelectedLocation(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number");
        }
        ((TileEntityMachineTransporter)this.machine).selectedLocation = (int)Math.floor((Double)args[0]);
        return null;
    }

    private Object[] computerSetName(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number");
        }
        if (!(args[1] instanceof String)) {
            throw new IllegalArgumentException("Argument 2 must be a string");
        }
        int locNum = (int)Math.floor((Double)args[0]);
        ((TileEntityMachineTransporter)this.machine).getPositions().get((int)locNum).name = (String)args[1];
        return null;
    }

    private Object[] computerSetX(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number");
        }
        if (!(args[1] instanceof Double)) {
            throw new IllegalArgumentException("Argument 2 must be a number");
        }
        int locNum = (int)Math.floor((Double)args[0]);
        ((TileEntityMachineTransporter)this.machine).getPositions().get((int)locNum).x = (int)Math.floor((Double)args[1]);
        return null;
    }

    private Object[] computerSetY(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number");
        }
        if (!(args[1] instanceof Double)) {
            throw new IllegalArgumentException("Argument 2 must be a number");
        }
        int locNum = (int)Math.floor((Double)args[0]);
        ((TileEntityMachineTransporter)this.machine).getPositions().get((int)locNum).y = (int)Math.floor((Double)args[1]);
        return null;
    }

    private Object[] computerSetZ(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number");
        }
        if (!(args[1] instanceof Double)) {
            throw new IllegalArgumentException("Argument 2 must be a number");
        }
        int locNum = (int)Math.floor((Double)args[0]);
        ((TileEntityMachineTransporter)this.machine).getPositions().get((int)locNum).z = (int)Math.floor((Double)args[1]);
        return null;
    }

    private Object[] computerSetRedstoneMode(Object[] args) {
        if (!(args[0] instanceof Double)) {
            throw new IllegalArgumentException("Argument 1 must be a number from 0 to 2");
        }
        int i = (int)Math.floor((Double)args[0]);
        if (i < 0 || i > 2) {
            throw new IllegalArgumentException("Argument 1 must be a number from 0 to 2");
        }
        IConfigProperty property = ((TileEntityMachineTransporter)this.machine).getConfigs().getProperty("redstoneMode");
        if (property == null) {
            throw new IllegalArgumentException("No redstone mode config found for machine");
        }
        property.setValue(i);
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            return this.callMethod(method, arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return methodNames;
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        int methodId = Arrays.asList(methodNames).indexOf(method);
        if (methodId == -1) {
            throw new RuntimeException("The method " + method + " does not exist");
        }
        return this.callMethod(methodId, args.toArray());
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return this.peripheralName;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    @Override
    public void update(TileEntityMachineTransporter machine) {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onActiveChange(TileEntityMachineTransporter machine) {
    }

    @Override
    public void onAwake(TileEntityMachineTransporter machine, Side side) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving, TileEntityMachineTransporter machine) {
    }
}

