/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import matteroverdrive.api.network.IMatterNetworkClient;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;
import matteroverdrive.tile.TileEntityMachinePatternStorage;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MatterNetworkComponentPatternStorage
extends MatterNetworkComponentClient<TileEntityMachinePatternStorage> {
    private TimeTracker taskProcessingTracker = new TimeTracker();

    public MatterNetworkComponentPatternStorage(TileEntityMachinePatternStorage patternStorage) {
        super(patternStorage);
        this.handlers.add(BASIC_CONNECTIONS_HANDLER);
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        super.executePacket(packet);
        if (packet instanceof MatterNetworkTaskPacket) {
            MatterNetworkTask task = ((MatterNetworkTaskPacket)packet).getTask(this.getWorldObj());
            if (task != null) {
                this.executeTasks((MatterNetworkTaskPacket)packet, task);
            }
        } else if (packet instanceof MatterNetworkRequestPacket) {
            this.executeRequests((MatterNetworkRequestPacket)packet);
        }
    }

    protected void executeTasks(MatterNetworkTaskPacket packet, MatterNetworkTask task) {
        TileEntityMachinePatternStorage cfr_ignored_0 = (TileEntityMachinePatternStorage)this.rootClient;
        if (this.taskProcessingTracker.hasDelayPassed(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w(), 40) && task.getState().belowOrEqual(MatterNetworkTaskState.QUEUED) && task instanceof MatterNetworkTaskStorePattern && ((TileEntityMachinePatternStorage)this.rootClient).addItem(((MatterNetworkTaskStorePattern)task).getItemStack(), ((MatterNetworkTaskStorePattern)task).getProgress(), false, null)) {
            task.setState(MatterNetworkTaskState.FINISHED);
        }
    }

    protected void executeRequests(MatterNetworkRequestPacket packet) {
        if (packet.getRequestType() == 1) {
            ItemPattern packPattern;
            ItemPattern storagePattern;
            if (packet.getRequest() instanceof ItemPattern && (storagePattern = ((TileEntityMachinePatternStorage)this.rootClient).getPattern(packPattern = (ItemPattern)packet.getRequest())) != null && packet.getSender(((TileEntityMachinePatternStorage)this.rootClient).func_145831_w()) instanceof IMatterNetworkClient) {
                NBTTagCompound patternNBT = new NBTTagCompound();
                storagePattern.writeToNBT(patternNBT);
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, 1, patternNBT);
            }
        } else if (packet.getRequestType() == 3 && packet.getRequest() instanceof ItemPattern) {
            ItemPattern packetPattern = (ItemPattern)packet.getRequest();
            ItemPattern storagePattern = ((TileEntityMachinePatternStorage)this.rootClient).getPattern(packetPattern);
            NBTTagCompound packetPatternNBT = new NBTTagCompound();
            packetPattern.writeToNBT(packetPatternNBT);
            if (storagePattern != null) {
                MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, storagePattern.getProgress() >= 100 ? 0 : 1, packetPatternNBT);
            } else {
                ItemStack itemStack = packetPattern.toItemStack(false);
                boolean canAddItem = ((TileEntityMachinePatternStorage)this.rootClient).addItem(itemStack, 20, true, null);
                if (canAddItem) {
                    MatterNetworkHelper.respondToRequest(this.getWorldObj(), (IMatterNetworkConnection)((Object)this.rootClient), packet, 1, packetPatternNBT);
                }
            }
        }
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        return super.canPreform(packet) && ((TileEntityMachinePatternStorage)this.rootClient).getRedstoneActive();
    }
}

