/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import cpw.mods.fml.common.gameevent.TickEvent;
import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.matter_network.MatterNetworkPacket;
import matteroverdrive.matter_network.components.MatterNetworkComponentClientDispatcher;
import matteroverdrive.matter_network.packets.MatterNetworkRequestPacket;
import matteroverdrive.matter_network.packets.MatterNetworkResponsePacket;
import matteroverdrive.matter_network.packets.MatterNetworkTaskPacket;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.tile.TileEntityMachineReplicator;
import matteroverdrive.util.MatterNetworkHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterNetworkComponentReplicator
extends MatterNetworkComponentClientDispatcher<MatterNetworkTaskReplicatePattern, TileEntityMachineReplicator> {
    private TimeTracker patternSearchTracker = new TimeTracker();

    public MatterNetworkComponentReplicator(TileEntityMachineReplicator replicator) {
        super(replicator, TickEvent.Phase.END);
        this.handlers.add(BASIC_CONNECTIONS_HANDLER);
    }

    @Override
    public boolean canPreform(MatterNetworkPacket packet) {
        if (super.canPreform(packet)) {
            if (packet instanceof MatterNetworkTaskPacket && ((MatterNetworkTaskPacket)packet).getTask(((TileEntityMachineReplicator)this.rootClient).func_145831_w()) instanceof MatterNetworkTaskReplicatePattern) {
                return ((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).remaintingCapacity() > 0;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void executePacket(MatterNetworkPacket packet) {
        super.executePacket(packet);
        if (packet instanceof MatterNetworkTaskPacket) {
            this.executeTasks((MatterNetworkTaskPacket)packet, ((MatterNetworkTaskPacket)packet).getTask(this.getWorldObj()));
        } else if (packet instanceof MatterNetworkResponsePacket) {
            this.executeResponses((MatterNetworkResponsePacket)packet);
        }
    }

    protected void executeTasks(MatterNetworkTaskPacket packet, MatterNetworkTask task) {
        if (task instanceof MatterNetworkTaskReplicatePattern && ((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).queue((MatterNetworkTaskReplicatePattern)task)) {
            task.setSender((IMatterNetworkConnection)((Object)this.rootClient));
            task.setState(MatterNetworkTaskState.PROCESSING);
            task.setAlive(true);
            ((TileEntityMachineReplicator)this.rootClient).forceSync();
        }
    }

    protected void executeResponses(MatterNetworkResponsePacket packet) {
        if (packet.getRequestType() == 1 && packet.getResponseType() == 1) {
            NBTTagCompound responseTag = packet.getResponse();
            ItemPattern responsePattern = new ItemPattern(responseTag);
            MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)((TileEntityMachineReplicator)this.rootClient).getTaskQueue(0).peek();
            if (responseTag != null && responsePattern.equals(task.getPattern())) {
                if (((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage() != null && ((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage().equals(responsePattern) && ((TileEntityMachineReplicator)this.rootClient).getInternalPatternStorage().getProgress() > responsePattern.getProgress()) {
                    return;
                }
                ((TileEntityMachineReplicator)this.rootClient).setInternalPatternStorage(responsePattern);
                ((TileEntityMachineReplicator)this.rootClient).forceSync();
            }
        }
    }

    @Override
    public int manageTopQueue(World world, int queueID, MatterNetworkTaskReplicatePattern task) {
        int broadcasts = 0;
        if (((TileEntityMachineReplicator)this.rootClient).getRedstoneActive() && !((TileEntityMachineReplicator)this.rootClient).canCompleteTask(task)) {
            TileEntityMachineReplicator cfr_ignored_0 = (TileEntityMachineReplicator)this.rootClient;
            if (this.patternSearchTracker.hasDelayPassed(world, 60) && task != null) {
                for (int i = 0; i < 6; ++i) {
                    MatterNetworkRequestPacket requestPacket = new MatterNetworkRequestPacket((IMatterNetworkConnection)((Object)this.rootClient), 1, ForgeDirection.getOrientation((int)i), ((TileEntityMachineReplicator)this.rootClient).getFilter(), task.getPattern());
                    if (!MatterNetworkHelper.broadcastPacketInDirection(world, requestPacket, (IMatterNetworkConnection)((Object)this.rootClient), ForgeDirection.getOrientation((int)i))) continue;
                    ++broadcasts;
                }
            }
        }
        return broadcasts;
    }
}

