/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.tasks;

import matteroverdrive.api.network.IMatterNetworkConnection;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MatterNetworkTaskReplicatePattern
extends MatterNetworkTask {
    ItemPattern pattern;

    public MatterNetworkTaskReplicatePattern() {
        this.pattern = new ItemPattern();
    }

    public MatterNetworkTaskReplicatePattern(IMatterNetworkConnection sender, short itemID, short itemMetadata, byte amount) {
        super(sender);
        this.pattern = new ItemPattern(itemID, (int)itemMetadata);
        this.pattern.setCount(amount);
    }

    public MatterNetworkTaskReplicatePattern(IMatterNetworkConnection sender, ItemPattern pattern) {
        super(sender);
        this.pattern = pattern;
    }

    @Override
    protected void init() {
        this.setUnlocalizedName("replicate_pattern");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound != null) {
            this.pattern.readFromNBT(compound.func_74775_l("Pattern"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (compound != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.pattern.writeToNBT(tagCompound);
            compound.func_74782_a("Pattern", (NBTBase)tagCompound);
        }
    }

    @Override
    public String getName() {
        return this.pattern.getCount() + " " + MOStringHelper.translateToLocal(this.pattern.getItem().func_77658_a() + ".name");
    }

    public ItemPattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isValid(World world) {
        if (!super.isValid(world)) {
            return false;
        }
        return MatterHelper.getMatterAmountFromItem(this.pattern.toItemStack(false)) > 0;
    }
}

