/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.network.packet.bi.PacketMatterScannerGetDatabase;
import matteroverdrive.network.packet.bi.PacketStarLoading;
import matteroverdrive.network.packet.bi.PacketWeaponTick;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.network.packet.client.PacketAndroidTransformation;
import matteroverdrive.network.packet.client.PacketMatterUpdate;
import matteroverdrive.network.packet.client.PacketPatternMonitorSync;
import matteroverdrive.network.packet.client.PacketPowerUpdate;
import matteroverdrive.network.packet.client.PacketReplicationComplete;
import matteroverdrive.network.packet.client.PacketSendMinimapInfo;
import matteroverdrive.network.packet.client.PacketSendQueueFlash;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import matteroverdrive.network.packet.client.PacketSyncAndroid;
import matteroverdrive.network.packet.client.PacketSyncTaskQueue;
import matteroverdrive.network.packet.client.PacketSyncTransportProgress;
import matteroverdrive.network.packet.client.PacketUpdateMatterRegistry;
import matteroverdrive.network.packet.client.quest.PacketSyncQuests;
import matteroverdrive.network.packet.client.quest.PacketUpdateQuest;
import matteroverdrive.network.packet.client.starmap.PacketUpdateGalaxy;
import matteroverdrive.network.packet.client.starmap.PacketUpdatePlanet;
import matteroverdrive.network.packet.client.starmap.PacketUpdateTravelEvents;
import matteroverdrive.network.packet.server.PacketAndroidChangeAbility;
import matteroverdrive.network.packet.server.PacketBioticActionKey;
import matteroverdrive.network.packet.server.PacketConversationInteract;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.network.packet.server.PacketDigBlock;
import matteroverdrive.network.packet.server.PacketManageConversation;
import matteroverdrive.network.packet.server.PacketMatterScannerUpdate;
import matteroverdrive.network.packet.server.PacketPatternMonitorCommands;
import matteroverdrive.network.packet.server.PacketQuestActions;
import matteroverdrive.network.packet.server.PacketReloadEnergyWeapon;
import matteroverdrive.network.packet.server.PacketRemoveTask;
import matteroverdrive.network.packet.server.PacketResetBioStats;
import matteroverdrive.network.packet.server.PacketSendMachineNBT;
import matteroverdrive.network.packet.server.PacketTeleportPlayer;
import matteroverdrive.network.packet.server.PacketUnlockBioticStat;
import matteroverdrive.network.packet.server.starmap.PacketStarMapAttack;
import matteroverdrive.network.packet.server.starmap.PacketStarMapClientCommands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

@ChannelHandler.Sharable
public class PacketPipeline {
    protected int packetID = 0;
    public SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("mo_channel");

    public void registerPackets() {
        this.registerPacket(PacketMatterScannerUpdate.ServerHandler.class, PacketMatterScannerUpdate.class);
        this.registerPacket(PacketPowerUpdate.ClientHandler.class, PacketPowerUpdate.class);
        this.registerPacket(PacketMatterUpdate.ClientHandler.class, PacketMatterUpdate.class);
        this.registerPacket(PacketPatternMonitorSync.ClientHandler.class, PacketPatternMonitorSync.class);
        this.registerPacket(PacketPatternMonitorCommands.ServerHandler.class, PacketPatternMonitorCommands.class);
        this.registerPacket(PacketReplicationComplete.ClientHandler.class, PacketReplicationComplete.class);
        this.registerPacket(PacketRemoveTask.ServerHandler.class, PacketRemoveTask.class);
        this.registerPacket(PacketSyncTransportProgress.ClientHandler.class, PacketSyncTransportProgress.class);
        this.registerBiPacket(PacketMatterScannerGetDatabase.Handler.class, PacketMatterScannerGetDatabase.class);
        this.registerPacket(PacketUpdateMatterRegistry.ClientHandler.class, PacketUpdateMatterRegistry.class);
        this.registerPacket(PacketSyncAndroid.ClientHandler.class, PacketSyncAndroid.class);
        this.registerPacket(PacketUnlockBioticStat.ServerHandler.class, PacketUnlockBioticStat.class);
        this.registerPacket(PacketTeleportPlayer.ServerHandler.class, PacketTeleportPlayer.class);
        this.registerPacket(PacketSpawnParticle.ClientHandler.class, PacketSpawnParticle.class);
        this.registerPacket(PacketUpdatePlanet.ClientHandler.class, PacketUpdatePlanet.class);
        this.registerPacket(PacketUpdateGalaxy.ClientHandler.class, PacketUpdateGalaxy.class);
        this.registerPacket(PacketStarMapClientCommands.ServerHandler.class, PacketStarMapClientCommands.class);
        this.registerPacket(PacketStarMapAttack.ServerHandler.class, PacketStarMapAttack.class);
        this.registerPacket(PacketUpdateTravelEvents.ClientHandler.class, PacketUpdateTravelEvents.class);
        this.registerPacket(PacketAndroidChangeAbility.ServerHandler.class, PacketAndroidChangeAbility.class);
        this.registerBiPacket(PacketFirePlasmaShot.BiHandler.class, PacketFirePlasmaShot.class);
        this.registerPacket(PacketReloadEnergyWeapon.ServerHandler.class, PacketReloadEnergyWeapon.class);
        this.registerBiPacket(PacketManageConversation.BiHandler.class, PacketManageConversation.class);
        this.registerPacket(PacketConversationInteract.ServerHandler.class, PacketConversationInteract.class);
        this.registerBiPacket(PacketSendMachineNBT.BiHandler.class, PacketSendMachineNBT.class);
        this.registerPacket(PacketSendQueueFlash.ClientHandler.class, PacketSendQueueFlash.class);
        this.registerPacket(PacketDataPadCommands.ServerHandler.class, PacketDataPadCommands.class);
        this.registerPacket(PacketSendMinimapInfo.ClientHandler.class, PacketSendMinimapInfo.class);
        this.registerPacket(PacketResetBioStats.ServerHandler.class, PacketResetBioStats.class);
        this.registerPacket(PacketDigBlock.ServerHandler.class, PacketDigBlock.class);
        this.registerPacket(PacketUpdateQuest.ClientHandler.class, PacketUpdateQuest.class);
        this.registerPacket(PacketSyncQuests.ClientHandler.class, PacketSyncQuests.class);
        this.registerPacket(PacketQuestActions.ServerHandler.class, PacketQuestActions.class);
        this.registerPacket(PacketWeaponTick.ServerHandler.class, PacketWeaponTick.class);
        this.registerBiPacket(PacketStarLoading.BiHandler.class, PacketStarLoading.class);
        this.registerPacket(PacketAndroidTransformation.ClientHandler.class, PacketAndroidTransformation.class);
        this.registerPacket(PacketSyncTaskQueue.ClientHandler.class, PacketSyncTaskQueue.class);
        this.registerPacket(PacketBioticActionKey.ServerHandler.class, PacketBioticActionKey.class);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerPacket(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType) {
        try {
            Side side = AbstractClientPacketHandler.class.isAssignableFrom(messageHandler) ? Side.CLIENT : Side.SERVER;
            this.dispatcher.registerMessage(messageHandler, requestMessageType, this.packetID++, side);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerBiPacket(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType) {
        if (!AbstractBiPacketHandler.class.isAssignableFrom(messageHandler)) {
            throw new IllegalArgumentException("Cannot register " + messageHandler.getName() + " on both sides - must extend AbstractBiMessageHandler!");
        }
        this.dispatcher.registerMessage(messageHandler, requestMessageType, this.packetID, Side.CLIENT);
        this.dispatcher.registerMessage(messageHandler, requestMessageType, this.packetID++, Side.SERVER);
    }

    public void sendToServer(IMessage message) {
        this.dispatcher.sendToServer(message);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.dispatcher.sendToAllAround(message, point);
    }

    public void sendToAllAround(IMessage message, int dimention, double x, double y, double z, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimention, x, y, z, range));
    }

    public void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, range));
    }

    public void sendToAllAround(IMessage message, TileEntity tileEntity, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(tileEntity.func_145831_w().field_73011_w.field_76574_g, (double)tileEntity.field_145851_c, (double)tileEntity.field_145848_d, (double)tileEntity.field_145849_e, range));
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.dispatcher.sendTo(message, player);
    }

    public void sendToDimention(IMessage message, int dimention) {
        this.dispatcher.sendToDimension(message, dimention);
    }

    public void sendToDimention(IMessage message, World world) {
        this.sendToDimention(message, world.field_73011_w);
    }

    public void sendToDimention(IMessage message, WorldProvider worldProvider) {
        this.dispatcher.sendToDimension(message, worldProvider.field_76574_g);
    }
}

