/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.bi;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.gui.GuiMatterScanner;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketMatterScannerGetDatabase
extends TileEntityUpdatePacket {
    List<ItemPattern> list;

    public PacketMatterScannerGetDatabase() {
    }

    public PacketMatterScannerGetDatabase(int x, int y, int z) {
        super(x, y, z);
    }

    public PacketMatterScannerGetDatabase(BlockPos position) {
        this(position.x, position.y, position.z);
    }

    public PacketMatterScannerGetDatabase(List<ItemPattern> list) {
        this.list = list;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.list.add(new ItemPattern(buf));
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.list.size());
        for (ItemPattern pattern : this.list) {
            pattern.writeToBuffer(buf);
        }
    }

    public static class Handler
    extends AbstractBiPacketHandler<PacketMatterScannerGetDatabase> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketMatterScannerGetDatabase message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof IMatterDatabase) {
                IMatterDatabase database = (IMatterDatabase)tileEntity;
                return new PacketMatterScannerGetDatabase(database.getPatterns());
            }
            return null;
        }

        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketMatterScannerGetDatabase message, MessageContext ctx) {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiMatterScanner) {
                GuiMatterScanner guiMatterScanner = (GuiMatterScanner)Minecraft.func_71410_x().field_71462_r;
                guiMatterScanner.UpdatePatternList(message.list);
            }
            return null;
        }
    }
}

