/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.util.MOEnumHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class PacketSyncAndroid
extends PacketAbstract {
    public static final int SYNC_ALL = -1;
    public static final int SYNC_BATTERY = 0;
    public static final int SYNC_EFFECTS = 1;
    public static final int SYNC_STATS = 2;
    public static final int SYNC_ACTIVE_ABILITY = 3;
    public static final int SYNC_INVENTORY = 4;
    NBTTagCompound data;
    int dataType;
    int playerID;

    public PacketSyncAndroid() {
        this.data = new NBTTagCompound();
    }

    public PacketSyncAndroid(AndroidPlayer player, EnumSet<AndroidPlayer.DataType> dataTypes) {
        this.dataType = MOEnumHelper.encode(dataTypes);
        this.playerID = player.getPlayer().func_145782_y();
        this.data = new NBTTagCompound();
        player.writeToNBT(this.data, dataTypes);
    }

    public void fromBytes(ByteBuf buf) {
        this.dataType = buf.readInt();
        this.playerID = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dataType);
        buf.writeInt(this.playerID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSyncAndroid> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketSyncAndroid message, MessageContext ctx) {
            Entity entity = player.field_70170_p.func_73045_a(message.playerID);
            if (entity instanceof EntityPlayer) {
                EntityPlayer source = (EntityPlayer)entity;
                AndroidPlayer ex = AndroidPlayer.get(source);
                ex.readFromNBT(message.data, MOEnumHelper.decode(message.dataType, AndroidPlayer.DataType.class));
            }
            return null;
        }
    }
}

