/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.starmap;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.TravelEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateTravelEvents
extends PacketAbstract {
    List<TravelEvent> travelEvents;

    public PacketUpdateTravelEvents() {
    }

    public PacketUpdateTravelEvents(Galaxy galaxy) {
        this.travelEvents = galaxy.getTravelEvents();
    }

    public void fromBytes(ByteBuf buf) {
        if (this.travelEvents == null) {
            this.travelEvents = new ArrayList<TravelEvent>();
        }
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.travelEvents.add(new TravelEvent(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.travelEvents.size());
        for (int i = 0; i < this.travelEvents.size(); ++i) {
            this.travelEvents.get(i).writeToBuffer(buf);
        }
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdateTravelEvents> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PacketUpdateTravelEvents message, MessageContext ctx) {
            GalaxyClient.getInstance().getTheGalaxy().setTravelEvents(message.travelEvents);
            this.notifyChange();
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void notifyChange() {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiStarMap) {
                GuiStarMap guiStarMap = (GuiStarMap)Minecraft.func_71410_x().field_71462_r;
                guiStarMap.onTravelEventsChange(GalaxyClient.getInstance().getTheGalaxy().getTravelEvents());
            }
        }
    }
}

