/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketDigBlock
extends PacketAbstract {
    int typeOfDig;
    int x;
    int y;
    int z;
    int side;

    public PacketDigBlock() {
    }

    public PacketDigBlock(int x, int y, int z, int typeOfDig, int side) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.typeOfDig = typeOfDig;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.side = buf.readByte();
        this.typeOfDig = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.side);
        buf.writeByte(this.typeOfDig);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketDigBlock> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketDigBlock message, MessageContext ctx) {
            WorldServer worldserver = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (message.typeOfDig == 0) {
                if (!MinecraftServer.func_71276_C().func_96290_a((World)worldserver, message.x, message.y, message.z, player)) {
                    playerMP.field_71134_c.func_73074_a(message.x, message.y, message.z, message.side);
                } else {
                    playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(message.x, message.y, message.z, (World)worldserver));
                }
            } else if (message.typeOfDig == 2) {
                playerMP.field_71134_c.func_73082_a(message.x, message.y, message.z);
                if (worldserver.func_147439_a(message.x, message.y, message.z).func_149688_o() != Material.field_151579_a) {
                    playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(message.x, message.y, message.z, (World)worldserver));
                }
            } else if (message.typeOfDig == 1) {
                playerMP.field_71134_c.func_73073_c(message.x, message.y, message.z);
                if (worldserver.func_147439_a(message.x, message.y, message.z).func_149688_o() != Material.field_151579_a) {
                    playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(message.x, message.y, message.z, (World)worldserver));
                }
            }
            return null;
        }
    }
}

