/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketPatternMonitorCommands
extends TileEntityUpdatePacket {
    public static final int COMMAND_SEARCH = 0;
    public static final int COMMAND_REQUEST = 1;
    int command;
    List<ItemPattern> patterns;

    public PacketPatternMonitorCommands() {
        this.patterns = new ArrayList<ItemPattern>();
    }

    public PacketPatternMonitorCommands(TileEntityMachinePatternMonitor monitor, int command, List<ItemPattern> patterns) {
        super(monitor);
        this.command = command;
        this.patterns = patterns;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.command = buf.readInt();
        if (this.command == 1) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.patterns.add(new ItemPattern(buf));
            }
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.command);
        if (this.command == 1) {
            buf.writeInt(this.patterns.size());
            for (ItemPattern pattern : this.patterns) {
                pattern.writeToBuffer(buf);
            }
        }
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketPatternMonitorCommands> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketPatternMonitorCommands message, MessageContext ctx) {
            TileEntity entity = message.getTileEntity(player.field_70170_p);
            if (entity != null && entity instanceof TileEntityMachinePatternMonitor) {
                TileEntityMachinePatternMonitor monitor = (TileEntityMachinePatternMonitor)entity;
                if (message.command == 0) {
                    monitor.queueSearch();
                } else if (message.command == 1 && message.patterns != null) {
                    monitor.queuePatternRequest(message.patterns);
                }
            }
            return null;
        }
    }
}

