/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOExtendedProperties;
import matteroverdrive.items.Contract;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.quest.PacketSyncQuests;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketQuestActions
extends PacketAbstract {
    public static final int QUEST_ACTION_ABONDON = 0;
    public static final int QUEST_ACTION_COMPLETE = 1;
    public static final int QUEST_ACTION_ADD = 2;
    int command;
    int questID;
    int playerID;

    public PacketQuestActions() {
    }

    public PacketQuestActions(int command, int questID, int playerID) {
        this.command = command;
        this.questID = questID;
        this.playerID = playerID;
    }

    public PacketQuestActions(int command, int questID, EntityPlayer entityPlayer) {
        this.command = command;
        this.questID = questID;
        this.playerID = entityPlayer.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.command = buf.readInt();
        this.questID = buf.readInt();
        this.playerID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.command);
        buf.writeInt(this.questID);
        buf.writeInt(this.playerID);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketQuestActions> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketQuestActions message, MessageContext ctx) {
            MOExtendedProperties extendedProperties;
            Entity entity = player.field_70170_p.func_73045_a(message.playerID);
            if (entity instanceof EntityPlayer && (extendedProperties = MOExtendedProperties.get((EntityPlayer)entity)) != null) {
                ItemStack contract;
                if (message.questID < extendedProperties.getQuestData().getActiveQuests().size()) {
                    if (message.command == 1) {
                        QuestStack questStack = extendedProperties.getQuestData().getActiveQuests().get(message.questID);
                        if (QuestStack.canComplete((EntityPlayer)entity, questStack)) {
                            questStack.markComplited(player, true);
                        }
                    } else if (message.command == 0) {
                        QuestStack abandonedQuest = extendedProperties.getQuestData().removeQuest(message.questID);
                        if (abandonedQuest != null) {
                            extendedProperties.onQuestAbandoned(abandonedQuest);
                        }
                        return new PacketSyncQuests(extendedProperties.getQuestData(), EnumSet.of(PlayerQuestData.DataType.ACTIVE_QUESTS));
                    }
                }
                if (message.command == 2 && (contract = extendedProperties.getPlayer().field_71071_by.func_70301_a(message.questID)).func_77973_b() instanceof Contract) {
                    extendedProperties.addQuest(((Contract)contract.func_77973_b()).getQuest(contract));
                    extendedProperties.getPlayer().field_71071_by.func_70298_a(message.questID, 1);
                }
            }
            return null;
        }
    }
}

