/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.BioticStatTeleport;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;

public class PacketTeleportPlayer
extends PacketAbstract {
    double x;
    double y;
    double z;

    public PacketTeleportPlayer() {
    }

    public PacketTeleportPlayer(Vec3 vec3) {
        this.x = vec3.field_72450_a;
        this.y = vec3.field_72448_b;
        this.z = vec3.field_72449_c;
    }

    public PacketTeleportPlayer(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketTeleportPlayer> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, PacketTeleportPlayer message, MessageContext ctx) {
            AndroidPlayer androidPlayer = AndroidPlayer.get(player);
            if (androidPlayer != null && androidPlayer.isAndroid() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(MatterOverdriveBioticStats.teleport, androidPlayer.getUnlockedLevel(MatterOverdriveBioticStats.teleport), androidPlayer))) {
                MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSpawnParticle("teleport", player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, 1, 0), player, 64.0);
                player.field_70170_p.func_85173_a(player, "mo:android_teleport", 0.2f, 0.8f + 0.4f * player.field_70170_p.field_73012_v.nextFloat());
                player.func_70634_a(message.x, message.y, message.z);
                player.field_70170_p.func_72908_a(message.x, message.y, message.z, "mo:android_teleport", 0.2f, 0.8f + 0.4f * player.field_70170_p.field_73012_v.nextFloat());
                androidPlayer.getEffects().func_74772_a("LastTeleport", player.field_70170_p.func_82737_E() + 40L);
                androidPlayer.getEffects().func_74768_a("GlitchTime", 5);
                androidPlayer.extractEnergyScaled(BioticStatTeleport.ENERGY_PER_TELEPORT);
                androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS));
                androidPlayer.getPlayer().field_70143_R = 0.0f;
            }
            return null;
        }
    }
}

