/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class GalaxyCommon {
    protected Galaxy theGalaxy;
    protected World world;
    protected Random random = new Random();
    protected HashMap<UUID, Planet> homePlanets = new HashMap();

    public void loadClaimedPlanets() {
        this.homePlanets.clear();
        for (Quadrant quadrant : this.theGalaxy.getQuadrants()) {
            for (Star star : quadrant.getStars()) {
                for (Planet planet : star.getPlanets()) {
                    if (!planet.isHomeworld() || !planet.hasOwner()) continue;
                    this.homePlanets.put(planet.getOwnerUUID(), planet);
                }
            }
        }
    }

    public Planet getPlanet(GalacticPosition position) {
        if (this.theGalaxy != null) {
            return this.theGalaxy.getPlanet(position);
        }
        return null;
    }

    public Star getStar(GalacticPosition position) {
        if (this.theGalaxy != null) {
            return this.theGalaxy.getStar(position);
        }
        return null;
    }

    public Quadrant getQuadrant(GalacticPosition position) {
        if (this.theGalaxy != null) {
            return this.theGalaxy.getQuadrant(position);
        }
        return null;
    }

    public Planet getHomeworld(EntityPlayer player) {
        return this.homePlanets.get(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public Galaxy getTheGalaxy() {
        return this.theGalaxy;
    }

    public void setTheGalaxy(Galaxy galaxy) {
        this.theGalaxy = galaxy;
        if (this.theGalaxy != null) {
            this.loadClaimedPlanets();
        }
    }
}

