/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.BuildingType;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.api.starmap.IBuildable;
import matteroverdrive.api.starmap.IBuilding;
import matteroverdrive.api.starmap.IPlanetStatChange;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.api.starmap.PlanetStatType;
import matteroverdrive.client.data.Color;
import matteroverdrive.network.packet.client.starmap.PacketUpdatePlanet;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.gen.ISpaceBodyGen;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class Planet
extends SpaceBody
implements IInventory {
    public static final int SLOT_COUNT = 4;
    private Star star;
    private float size;
    private float orbit;
    private byte type;
    private UUID ownerUUID;
    private ItemStack[] inventory;
    private List<ItemStack> buildings;
    private List<ItemStack> fleet;
    private boolean isDirty;
    private boolean homeworld;
    private boolean generated;
    private boolean needsClientUpdate;
    private int buildingSpaces;
    private int fleetSpaces;
    private int seed;

    public Planet() {
        this.init();
    }

    public Planet(String name, int id) {
        super(name, id);
        this.init();
    }

    private void init() {
        this.inventory = new ItemStack[4];
        this.buildings = new ArrayList<ItemStack>();
        this.fleet = new ArrayList<ItemStack>();
    }

    public void update(World world) {
        if (!world.field_72995_K) {
            if (this.needsClientUpdate) {
                this.needsClientUpdate = false;
                MatterOverdrive.packetPipeline.sendToDimention((IMessage)new PacketUpdatePlanet(this), world);
            }
            for (int i = 0; i < 4; ++i) {
                ArrayList<String> buildInfo = new ArrayList<String>();
                ItemStack buildableStack = this.func_70301_a(i);
                if (buildableStack == null) continue;
                if (buildableStack.func_77973_b() instanceof IBuilding) {
                    if (this.canBuild((IBuilding)buildableStack.func_77973_b(), buildableStack, buildInfo)) {
                        if (!((IBuilding)buildableStack.func_77973_b()).isReadyToBuild(world, buildableStack, this)) continue;
                        this.buildings.add(buildableStack);
                        if (this.getOwnerUUID() != null) {
                            ((IBuilding)buildableStack.func_77973_b()).setOwner(buildableStack, this.getOwnerUUID());
                        }
                        this.func_70299_a(i, null);
                        this.onBuild((IBuilding)buildableStack.func_77973_b(), buildableStack, world);
                        this.func_70296_d();
                        continue;
                    }
                    ((IBuilding)buildableStack.func_77973_b()).setBuildStart(buildableStack, world.func_82737_E());
                    this.func_70296_d();
                    continue;
                }
                if (!(buildableStack.func_77973_b() instanceof IShip)) continue;
                if (this.canBuild((IShip)buildableStack.func_77973_b(), buildableStack, buildInfo)) {
                    if (!((IShip)buildableStack.func_77973_b()).isReadyToBuild(world, buildableStack, this)) continue;
                    this.fleet.add(buildableStack);
                    if (this.getOwnerUUID() != null) {
                        ((IShip)buildableStack.func_77973_b()).setOwner(buildableStack, this.getOwnerUUID());
                    }
                    this.func_70299_a(i, null);
                    this.onBuild((IShip)buildableStack.func_77973_b(), buildableStack, world);
                    this.func_70296_d();
                    continue;
                }
                ((IShip)buildableStack.func_77973_b()).setBuildStart(buildableStack, world.func_82737_E());
                this.func_70296_d();
            }
        }
    }

    public void onSave(File file, World world) {
        this.isDirty = false;
    }

    public void onTravelEvent(ItemStack ship, GalacticPosition from, World world) {
        if (!world.field_72995_K && ship.func_77973_b() instanceof IShip) {
            EntityPlayer owner;
            UUID ownerID = ((IShip)ship.func_77973_b()).getOwnerID(ship);
            if (ownerID != null && (owner = world.func_152378_a(ownerID)) != null) {
                owner.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + "MatterOverdrive: Community Edition" + "]" + EnumChatFormatting.RESET + String.format(MOStringHelper.translateToLocal("alert.starmap.ship_arrive"), ship.func_82833_r(), this.name)));
            }
            ((IShip)ship.func_77973_b()).onTravel(ship, this);
            if (ship.field_77994_a <= 0) {
                this.removeShip(ship);
            }
            this.func_70296_d();
            this.markForUpdate();
        }
    }

    public void onBuild(IBuildable buildable, ItemStack buildableStack, World world) {
        EntityPlayer entityPlayer;
        UUID ownerID = buildable.getOwnerID(buildableStack);
        if (ownerID != null && (entityPlayer = world.func_152378_a(ownerID)) != null) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[" + "MatterOverdrive: Community Edition" + "]" + EnumChatFormatting.RESET + String.format(MOStringHelper.translateToLocal("alert.starmap.on_build"), buildableStack.func_82833_r(), this.name)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        int i;
        super.writeToNBT(tagCompound);
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.func_70301_a(i).func_77955_b(itemTag);
            tagCompound.func_74782_a("Slot" + i, (NBTBase)itemTag);
        }
        for (i = 0; i < this.buildings.size(); ++i) {
            NBTTagCompound buiildingTAG = new NBTTagCompound();
            this.buildings.get(i).func_77955_b(buiildingTAG);
            tagCompound.func_74782_a("Building" + i, (NBTBase)buiildingTAG);
        }
        for (i = 0; i < this.fleet.size(); ++i) {
            NBTTagCompound shipTag = new NBTTagCompound();
            this.fleet.get(i).func_77955_b(shipTag);
            tagCompound.func_74782_a("Ship" + i, (NBTBase)shipTag);
        }
        if (this.ownerUUID != null) {
            tagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        tagCompound.func_74757_a("Homeworld", this.homeworld);
        tagCompound.func_74776_a("Size", this.size);
        tagCompound.func_74774_a("Type", this.type);
        tagCompound.func_74776_a("Orbit", this.orbit);
        tagCompound.func_74768_a("BuildingSpaces", this.buildingSpaces);
        tagCompound.func_74768_a("FleetSpaces", this.fleetSpaces);
        tagCompound.func_74768_a("Seed", this.seed);
    }

    @Override
    public void writeToBuffer(ByteBuf byteBuf) {
        super.writeToBuffer(byteBuf);
        NBTTagCompound nbtData = new NBTTagCompound();
        this.writeToNBT(nbtData);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)nbtData);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound, GalaxyGenerator generator) {
        int i;
        super.readFromNBT(tagCompound, generator);
        this.buildings.clear();
        this.fleet.clear();
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (!tagCompound.func_150297_b("Slot" + i, 10)) continue;
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Slot" + i)));
        }
        this.buildingSpaces = tagCompound.func_74762_e("BuildingSpaces");
        for (i = 0; i < this.getBuildingSpaces(); ++i) {
            if (!tagCompound.func_150297_b("Building" + i, 10)) continue;
            ItemStack buildingStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Building" + i));
            if (buildingStack != null) {
                this.addBuilding(buildingStack);
                continue;
            }
            MOLog.error("There was a problem loading a building from NBT of planet %s", this.getName());
        }
        this.fleetSpaces = tagCompound.func_74762_e("FleetSpaces");
        for (i = 0; i < this.getFleetSpaces(); ++i) {
            if (!tagCompound.func_150297_b("Ship" + i, 10)) continue;
            ItemStack shipStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Ship" + i));
            if (shipStack != null) {
                this.addShip(shipStack);
                continue;
            }
            MOLog.error("There was a problem loading a ship from NBT of planet %s", this.getName());
        }
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            try {
                this.ownerUUID = UUID.fromString(tagCompound.func_74779_i("OwnerUUID"));
            }
            catch (IllegalArgumentException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)("Invalid planet owner UUID '" + tagCompound.func_74779_i("OwnerUUID") + "'"), (Object[])new Object[]{this});
            }
        }
        this.homeworld = tagCompound.func_74767_n("Homeworld");
        this.size = tagCompound.func_74760_g("Size");
        this.type = tagCompound.func_74771_c("Type");
        this.orbit = tagCompound.func_74760_g("Orbit");
        this.seed = tagCompound.func_74762_e("Seed");
        this.generateMissing(tagCompound, generator);
    }

    @Override
    public void readFromBuffer(ByteBuf byteBuf) {
        super.readFromBuffer(byteBuf);
        NBTTagCompound nbtData = ByteBufUtils.readTag((ByteBuf)byteBuf);
        this.readFromNBT(nbtData, null);
    }

    public void generateMissing(NBTTagCompound tagCompound, GalaxyGenerator galaxyGenerator) {
        if (galaxyGenerator != null) {
            for (ISpaceBodyGen<Planet> starGen : galaxyGenerator.getPlanetGen().getGens()) {
                galaxyGenerator.getStarRandom().setSeed(this.seed);
                if (!starGen.generateMissing(tagCompound, this, galaxyGenerator.getStarRandom())) continue;
                break;
            }
        }
    }

    @Override
    public SpaceBody getParent() {
        return this.star;
    }

    public void setStar(Star star) {
        this.star = star;
    }

    public Star getStar() {
        return this.star;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwner(EntityPlayer player) {
        this.ownerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public boolean isOwner(EntityPlayer player) {
        if (this.hasOwner()) {
            return this.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
        }
        return false;
    }

    public void setHomeworld(boolean homeworld) {
        this.homeworld = homeworld;
    }

    public boolean isHomeworld() {
        return this.homeworld;
    }

    public boolean isHomeworld(EntityPlayer player) {
        if (this.isOwner(player)) {
            return this.isHomeworld();
        }
        return false;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public float getOrbit() {
        return this.orbit;
    }

    public void setOrbit(float orbit) {
        this.orbit = orbit;
    }

    public int getBuildingSpaces() {
        return (int)this.getStatChangeFromBuildings(PlanetStatType.BUILDINGS_SIZE, this.buildingSpaces);
    }

    public void setBuildingSpaces(int buildingSpaces) {
        this.buildingSpaces = buildingSpaces;
    }

    public List<ItemStack> getBuildings() {
        return this.buildings;
    }

    public List<ItemStack> getFleet() {
        return this.fleet;
    }

    public int getFleetSpaces() {
        return (int)this.getStatChangeFromBuildings(PlanetStatType.FLEET_SIZE, this.fleetSpaces);
    }

    public void setFleetSpaces(int fleetSpaces) {
        this.fleetSpaces = fleetSpaces;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public ItemStack getShip(int at) {
        return this.fleet.get(at);
    }

    public int getPopulation() {
        return (int)this.getStatChangeFromBuildings(PlanetStatType.POPULATION_COUNT, 0.0f);
    }

    public int getPowerProducation() {
        return (int)this.getStatChangeFromBuildings(PlanetStatType.ENERGY_PRODUCTION, 0.0f);
    }

    public float getMatterProduction() {
        return this.getStatChangeFromBuildings(PlanetStatType.MATTER_PRODUCTION, 0.0f);
    }

    public float getHappiness() {
        return this.getStatChangeFromBuildings(PlanetStatType.HAPPINESS, 0.0f);
    }

    public void addShip(ItemStack ship) {
        if (ship != null) {
            if (ship.func_77973_b() instanceof IShip) {
                this.fleet.add(ship);
            } else {
                MOLog.error("Trying to add an itemstack to ships, that does not contain a Ship Item", new Object[0]);
            }
        } else {
            MOLog.error("Trying to add a null Ship itemstack to %s", this.getName());
        }
    }

    public boolean canAddShip(ItemStack ship, @Nullable EntityPlayer player) {
        if (ship != null && ship.func_77973_b() instanceof IShip) {
            if (player != null && this.hasOwner() && this.isHomeworld()) {
                return this.isOwner(player);
            }
            if (this.fleetCount() < this.getFleetCount()) {
                return true;
            }
        }
        return false;
    }

    public ItemStack removeShip(int at) {
        if (at < this.fleet.size()) {
            return this.fleet.remove(at);
        }
        return null;
    }

    public boolean removeShip(ItemStack ship) {
        return this.fleet.remove(ship);
    }

    public void addBuilding(@Nonnull ItemStack building) {
        if (building != null) {
            if (building.func_77973_b() instanceof IBuilding) {
                this.buildings.add(building);
            } else {
                MOLog.error("Trying to add a stack to buildings, that does not contain a Building Item", new Object[0]);
            }
        } else {
            MOLog.error("Trying to add a null building to planet %s", this.getName());
        }
    }

    public int fleetCount() {
        return this.fleet.size();
    }

    public static Color getGuiColor(Planet planet) {
        if (planet.hasOwner()) {
            if (planet.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)Minecraft.func_71410_x().field_71439_g.func_146103_bH()))) {
                if (planet.isHomeworld()) {
                    return Reference.COLOR_HOLO_YELLOW;
                }
                return Reference.COLOR_HOLO_GREEN;
            }
            return Reference.COLOR_HOLO_RED;
        }
        return Reference.COLOR_HOLO;
    }

    public void markForUpdate() {
        this.needsClientUpdate = true;
    }

    public boolean canBuild(IBuildable buildable, ItemStack stack, List<String> info) {
        if (buildable instanceof IBuilding) {
            return this.canBuild((IBuilding)buildable, stack, info);
        }
        if (buildable instanceof IShip) {
            return this.canBuild((IShip)buildable, stack, info);
        }
        return false;
    }

    public boolean canBuild(IBuilding building, ItemStack stack, List<String> info) {
        if (this.buildings.size() < this.getBuildingSpaces()) {
            if (this.hasBuildingType(BuildingType.BASE)) {
                return building.canBuild(stack, this, info);
            }
            info.add(MOStringHelper.translateToLocal("gui.tooltip.starmap.no_base"));
        }
        info.add(MOStringHelper.translateToLocal("gui.tooltip.starmap.no_building_space"));
        return false;
    }

    public boolean canBuild(IShip ship, ItemStack stack, List<String> info) {
        if (this.fleet.size() < this.getFleetSpaces()) {
            if (this.hasBuildingType(BuildingType.SHIP_FACTORY)) {
                return ship.canBuild(stack, this, info);
            }
            info.add(MOStringHelper.translateToLocal("gui.tooltip.starmap.no_ship_factory"));
        } else {
            info.add(MOStringHelper.translateToLocal("gui.tooltip.starmap.no_ship_space"));
        }
        return false;
    }

    public boolean hasBuildingType(BuildingType buildingType) {
        for (ItemStack building : this.getBuildings()) {
            if (!(building.func_77973_b() instanceof IBuilding) || ((IBuilding)building.func_77973_b()).getType(building) != buildingType) continue;
            return true;
        }
        return false;
    }

    public float getStatChangeFromBuildings(PlanetStatType statType, float original) {
        for (ItemStack building : this.getBuildings()) {
            if (!(building.func_77973_b() instanceof IPlanetStatChange)) continue;
            original = ((IPlanetStatChange)building.func_77973_b()).changeStat(building, this, statType, original);
        }
        return original;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public int getFactoryCount() {
        return this.buildings.size();
    }

    public int getFleetCount() {
        return this.fleet.size();
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.inventory.length) {
            this.inventory[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return this.getName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.isDirty = true;
        this.markForUpdate();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.hasOwner()) {
            return this.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
        }
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 2) {
            return stack.func_77973_b() instanceof IBuilding;
        }
        return stack.func_77973_b() instanceof IShip;
    }
}

