/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.MachineMatterStorage;
import matteroverdrive.fluids.FluidMatterPlasma;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.client.PacketMatterUpdate;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class MOTileEntityMachineMatter
extends MOTileEntityMachineEnergy
implements IMatterHandler,
IWailaBodyProvider,
IFluidHandler {
    protected MachineMatterStorage matterStorage = new MachineMatterStorage<MOTileEntityMachineMatter>(this, 32768);

    public MOTileEntityMachineMatter(int upgradesCount) {
        super(upgradesCount);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA) && this.getMatterStorage() != null) {
            this.getMatterStorage().writeToNBT(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA) && this.getMatterStorage() != null) {
            this.getMatterStorage().readFromNBT(nbt);
        }
    }

    @Override
    public int getMatterStored() {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().getMatterStored();
        }
        return 0;
    }

    @Override
    public int getMatterCapacity() {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().getCapacity();
        }
        return 0;
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().receiveMatter(side, amount, simulate);
        }
        return 0;
    }

    @Override
    public int extractMatter(ForgeDirection direction, int amount, boolean simulate) {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().extractMatter(direction, amount, simulate);
        }
        return 0;
    }

    protected int modifyEnergyStored(int amount) {
        int energyModified = this.energyStorage.modifyEnergyStored(amount);
        if (energyModified != 0) {
            this.UpdateClientPower();
        }
        return energyModified;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getMatterStorage() != null) {
            return this.getMatterStorage().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getMatterStorage() != null) {
            return new FluidTankInfo[]{this.getMatterStorage().getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public MachineMatterStorage getMatterStorage() {
        return this.matterStorage;
    }

    public void setMatterStored(int matter) {
        if (this.getMatterStorage() != null) {
            this.getMatterStorage().setMatterStored(matter);
        }
    }

    public void updateClientMatter() {
        MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketMatterUpdate(this), this, 64.0);
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (itemStack != null && this.getMatterStorage() != null && itemStack.func_77942_o()) {
            this.getMatterStorage().readFromNBT(itemStack.func_77978_p());
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (itemStack != null && this.getMatterStorage() != null && this.getMatterStorage().getMatterStored() > 0) {
            if (!itemStack.func_77942_o()) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            this.getMatterStorage().writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("MaxMatter", this.matterStorage.getCapacity());
            itemStack.func_77978_p().func_74768_a("MatterSend", this.matterStorage.getMaxExtract());
            itemStack.func_77978_p().func_74768_a("MatterReceive", this.matterStorage.getMaxReceive());
        }
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof MOTileEntityMachineMatter)) {
            throw new RuntimeException("MOTileEntityMachineMatter WAILA provider is being used for something that is not a MOTileEntityMachineMatter: " + te.getClass());
        }
        MOTileEntityMachineMatter machine = (MOTileEntityMachineMatter)te;
        currenttip.add(EnumChatFormatting.AQUA + String.format("%s / %s %s", machine.getMatterStored(), machine.getMatterCapacity(), " kM"));
        return currenttip;
    }
}

