/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.weapon.IWeaponColor;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.ModuleSlot;
import matteroverdrive.data.inventory.TeleportFlashDriveSlot;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.items.TransportFlashDrive;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.configs.ConfigPropertyInteger;
import matteroverdrive.machines.configs.ConfigPropertyString;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityAndroidSpawner
extends MOTileEntityMachine {
    public int FLASH_DRIVE_SLOT_START;
    public static final int FLASH_DRIVE_COUNT = 6;
    public int COLOR_MODULE_SLOT;
    private Set<EntityRougeAndroidMob> spawnedAndroids = new HashSet<EntityRougeAndroidMob>();

    public TileEntityAndroidSpawner() {
        super(0);
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.COLOR_MODULE_SLOT = inventory.AddSlot(new ModuleSlot(true, 1, null));
        TeleportFlashDriveSlot slot = new TeleportFlashDriveSlot(false);
        slot.setKeepOnDismante(true);
        this.FLASH_DRIVE_SLOT_START = inventory.AddSlot(slot);
        for (int i = 0; i < 5; ++i) {
            slot = new TeleportFlashDriveSlot(false);
            slot.setKeepOnDismante(true);
            inventory.AddSlot(slot);
        }
        super.RegisterSlots(inventory);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isActive() && (this.getSpawnDelay() == 0 || this.field_145850_b.func_82737_E() % (long)this.getSpawnDelay() == 0L)) {
            for (int i = this.spawnedAndroids.size(); i < this.getMaxSpawnCount(); ++i) {
                EntityRougeAndroidMob entity = random.nextInt(10) < 3 ? new EntityMeleeRougeAndroidMob(this.field_145850_b) : new EntityRangedRogueAndroidMob(this.field_145850_b);
                double spawnRange = this.getSpawnRange();
                double x = (double)this.field_145851_c + MathHelper.func_151237_a((double)this.field_145850_b.field_73012_v.nextGaussian(), (double)0.0, (double)1.0) * spawnRange;
                double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(3) - 1;
                double z = (double)this.field_145849_e + MathHelper.func_151237_a((double)this.field_145850_b.field_73012_v.nextGaussian(), (double)0.0, (double)1.0) * spawnRange;
                int topY = this.field_145850_b.func_72976_f((int)x, (int)z);
                topY = Math.min(topY, this.field_145848_d + 3);
                entity.func_70012_b(x, topY, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!entity.getCanSpawnHere(true, true, true)) continue;
                entity.func_110161_a(null);
                entity.setSpawnerPosition(new BlockPos(this));
                entity.func_110163_bv();
                this.addSpawnedAndroid(entity);
                this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
                ScorePlayerTeam team = this.getTeam();
                if (team != null) {
                    entity.setTeam(team);
                    if (this.inventory.func_70301_a(this.COLOR_MODULE_SLOT) != null && this.inventory.func_70301_a(this.COLOR_MODULE_SLOT).func_77973_b() instanceof IWeaponColor) {
                        entity.setVisorColor(((IWeaponColor)this.inventory.func_70301_a(this.COLOR_MODULE_SLOT).func_77973_b()).getColor(this.inventory.func_70301_a(this.COLOR_MODULE_SLOT), null));
                        if (entity.func_70694_bm() != null) {
                            WeaponHelper.setModuleAtSlot(1, entity.func_70694_bm(), this.inventory.func_70301_a(this.COLOR_MODULE_SLOT));
                        }
                    }
                }
                this.spawnEntity(entity);
                entity.func_70656_aK();
                this.forceSync();
            }
        }
    }

    public ScorePlayerTeam getTeam() {
        String teamName = this.getTeamName();
        if (teamName != null && !teamName.isEmpty()) {
            return this.field_145850_b.func_96441_U().func_96508_e(teamName);
        }
        return null;
    }

    public boolean isTeamValid() {
        String teamName = this.getTeamName();
        if (teamName != null && !teamName.isEmpty()) {
            return this.field_145850_b.func_96441_U().func_96508_e(teamName) != null;
        }
        return true;
    }

    public void assignPath(EntityRougeAndroidMob androidMob) {
        ArrayList<Vec3> paths = new ArrayList<Vec3>();
        for (int i = this.FLASH_DRIVE_SLOT_START; i < 6; ++i) {
            BlockPos position;
            ItemStack flashDrive = this.inventory.getSlot(i).getItem();
            if (flashDrive == null || !(flashDrive.func_77973_b() instanceof TransportFlashDrive) || (position = ((TransportFlashDrive)flashDrive.func_77973_b()).getTraget(flashDrive)) == null) continue;
            paths.add(Vec3.func_72443_a((double)position.x, (double)position.y, (double)position.z));
        }
        if (paths.size() <= 0) {
            androidMob.setPath(new Vec3[]{Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)}, this.getSpawnRange());
        } else {
            androidMob.setPath(paths.toArray(new Vec3[0]), this.getSpawnRange());
        }
    }

    public int getMaxSpawnCount() {
        return this.configs.getInteger("max_spawn_amount", 6);
    }

    public int getSpawnRange() {
        return this.configs.getInteger("spawn_range", 4);
    }

    public String getTeamName() {
        return this.configs.getString("team", null);
    }

    public int getSpawnDelay() {
        return this.configs.getInteger("spawn_delay", 300);
    }

    public int getSpawnedCount() {
        return this.spawnedAndroids.size();
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.configs.addProperty(new ConfigPropertyInteger("max_spawn_amount", "gui.config.spawn_amount", 0, 32, 6));
        this.configs.addProperty(new ConfigPropertyInteger("spawn_range", "gui.config.spawn_range", 0, 32, 4));
        this.configs.addProperty(new ConfigPropertyInteger("spawn_delay", "gui.config.spawn_delay", 0, 100000, 300));
        this.configs.addProperty(new ConfigPropertyString("team", "gui.config.team", ""));
    }

    public EntityRougeAndroidMob spawnEntity(EntityRougeAndroidMob entity) {
        this.field_145850_b.func_72838_d((Entity)entity);
        return entity;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.getRedstoneActive() && this.isTeamValid() && this.spawnedAndroids.size() <= this.getMaxSpawnCount();
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    protected void onAwake(Side side) {
        if (side == Side.SERVER) {
            for (Entity entity : this.field_145850_b.field_72996_f) {
                if (!(entity instanceof EntityRougeAndroidMob) || !((EntityRougeAndroidMob)entity).wasSpawnedFrom(this)) continue;
                this.addSpawnedAndroid((EntityRougeAndroidMob)entity);
                this.assignPath((EntityRougeAndroidMob)entity);
            }
        }
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
        this.removeAllAndroids();
    }

    public void removeAllAndroids() {
        for (EntityRougeAndroidMob androidMob : this.spawnedAndroids) {
            androidMob.field_70128_L = true;
        }
        this.spawnedAndroids.clear();
    }

    public void addSpawnedAndroid(EntityRougeAndroidMob androidMob) {
        if (!this.spawnedAndroids.contains(androidMob)) {
            this.spawnedAndroids.add(androidMob);
            this.assignPath(androidMob);
        }
    }

    public void removeAndroid(EntityRougeAndroidMob androidMob) {
        if (this.spawnedAndroids.remove(androidMob)) {
            // empty if block
        }
    }
}

