/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.events.anomaly.MOEventGravitationalAnomalyConsume;
import matteroverdrive.api.gravity.AnomalySuppressor;
import matteroverdrive.api.gravity.IGravitationalAnomaly;
import matteroverdrive.api.gravity.IGravityEntity;
import matteroverdrive.client.sound.GravitationalAnomalySound;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.fx.GravitationalAnomalyParticle;
import matteroverdrive.init.MatterOverdriveBioticStats;
import matteroverdrive.items.SpacetimeEqualizer;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.IMOTickable;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.TimeTracker;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityGravitationalAnomaly
extends MOTileEntity
implements IScannable,
IMOTickable,
IGravitationalAnomaly {
    public static boolean FALLING_BLOCKS = true;
    public static boolean BLOCK_ENTITIES = true;
    public static boolean VANILLA_FLUIDS = true;
    public static boolean FORGE_FLUIDS = true;
    public static boolean BLOCK_DESTRUCTION = true;
    public static boolean GRAVITATION = true;
    public static final float MAX_VOLUME = 0.5f;
    public static final int BLOCK_DESTROY_DELAY = 6;
    public static final int MAX_BLOCKS_PER_HARVEST = 6;
    public static final int MAX_LIQUIDS_PER_HARVEST = 32;
    public static final double STRENGTH_MULTIPLIER = 1.0E-5;
    public static final double G = 6.67384;
    public static final double G2 = 13.34768;
    public static final double C = 2.99792458;
    public static final double CC = 8.987551787368176;
    @SideOnly(value=Side.CLIENT)
    private GravitationalAnomalySound sound;
    private TimeTracker blockDestroyTimer = new TimeTracker();
    private long mass = 2048L + Math.round(Math.random() * 8192.0);
    PriorityQueue<PositionWrapper> blocks;
    List<AnomalySuppressor> supressors = new ArrayList<AnomalySuppressor>();
    private float suppression;
    private Vec3 blockPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private Vec3 entityPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private Vec3 dir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private Vec3 intersectDir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);

    public TileEntityGravitationalAnomaly() {
    }

    public TileEntityGravitationalAnomaly(int mass) {
        this();
        this.mass = mass;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles(this.field_145850_b);
            this.manageSound();
            this.manageClientEntityGravitation(this.field_145850_b);
        }
    }

    @Override
    public void onServerTick(TickEvent.Phase phase, World world) {
        if (this.field_145850_b == null) {
            return;
        }
        if (phase.equals((Object)TickEvent.Phase.END)) {
            float tmpSuppression = this.calculateSuppression();
            if (tmpSuppression != this.suppression) {
                this.suppression = tmpSuppression;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.manageEntityGravitation(this.field_145850_b, 0.0f);
            this.manageBlockDestroy(this.field_145850_b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world) {
        double radius = (float)this.getBlockBreakRange();
        Vector3f point = MOMathHelper.randomSpherePoint((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, Vec3.func_72443_a((double)radius, (double)radius, (double)radius), world.field_73012_v);
        GravitationalAnomalyParticle particle = new GravitationalAnomalyParticle(world, point.x, point.y, point.z, Vec3.func_72443_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f)));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @SideOnly(value=Side.CLIENT)
    public void manageClientEntityGravitation(World world) {
        if (!GRAVITATION) {
            return;
        }
        double rangeSq = this.getMaxRange() + 1.0;
        rangeSq *= rangeSq;
        this.blockPos.field_72450_a = (double)this.field_145851_c + 0.5;
        this.blockPos.field_72448_b = (double)this.field_145848_d + 0.5;
        this.blockPos.field_72449_c = (double)this.field_145849_e + 0.5;
        this.entityPos.field_72450_a = Minecraft.func_71410_x().field_71439_g.field_70165_t;
        this.entityPos.field_72448_b = Minecraft.func_71410_x().field_71439_g.field_70163_u + (double)(Minecraft.func_71410_x().field_71439_g.func_70047_e() / 2.0f);
        this.entityPos.field_72449_c = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        double distanceSq = this.entityPos.func_72436_e(this.blockPos);
        if (distanceSq < rangeSq) {
            if (Minecraft.func_71410_x().field_71439_g.func_71124_b(3) != null && Minecraft.func_71410_x().field_71439_g.func_71124_b(3).func_77973_b() instanceof SpacetimeEqualizer || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75102_a || AndroidPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).isUnlocked(MatterOverdriveBioticStats.equalizer, 0)) {
                return;
            }
            double acceleration = this.getAcceleration(distanceSq);
            this.dir.field_72450_a = this.blockPos.field_72450_a - this.entityPos.field_72450_a;
            this.dir.field_72448_b = this.blockPos.field_72448_b - this.entityPos.field_72448_b;
            this.dir.field_72449_c = this.blockPos.field_72449_c - this.entityPos.field_72449_c;
            this.normalize(this.dir);
            Minecraft.func_71410_x().field_71439_g.func_70024_g(this.dir.field_72450_a * acceleration, this.dir.field_72448_b * acceleration, this.dir.field_72449_c * acceleration);
            Minecraft.func_71410_x().field_71439_g.field_70133_I = true;
        }
    }

    public void manageEntityGravitation(World world, float ticks) {
        if (!GRAVITATION) {
            return;
        }
        double range = this.getMaxRange() + 1.0;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List entities = world.func_72872_a(Entity.class, bb);
        this.blockPos.field_72450_a = (double)this.field_145851_c + 0.5;
        this.blockPos.field_72448_b = (double)this.field_145848_d + 0.5;
        this.blockPos.field_72449_c = (double)this.field_145849_e + 0.5;
        for (Object entityObject : entities) {
            ItemStack eq;
            Entity entity;
            if (!(entityObject instanceof Entity) || (entity = (Entity)entityObject) instanceof IGravityEntity && !((IGravityEntity)entity).isAffectedByAnomaly(this)) continue;
            this.entityPos.field_72450_a = entity.field_70165_t;
            this.entityPos.field_72448_b = entity.field_70163_u;
            this.entityPos.field_72449_c = entity.field_70161_v;
            double distanceSq = this.entityPos.func_72436_e(this.blockPos);
            double acceleration = this.getAcceleration(distanceSq);
            double eventHorizon = this.getEventHorizon();
            this.dir.field_72450_a = this.blockPos.field_72450_a - this.entityPos.field_72450_a;
            this.dir.field_72448_b = this.blockPos.field_72448_b - this.entityPos.field_72448_b;
            this.dir.field_72449_c = this.blockPos.field_72449_c - this.entityPos.field_72449_c;
            this.normalize(this.dir);
            this.dir.field_72450_a *= acceleration;
            this.dir.field_72448_b *= acceleration;
            this.dir.field_72449_c *= acceleration;
            if (this.intersectsAnomaly(this.entityPos, this.dir, this.blockPos, eventHorizon)) {
                this.consume(entity);
            }
            if (entityObject instanceof EntityLivingBase && (eq = ((EntityLivingBase)entityObject).func_71124_b(3)) != null && eq.func_77973_b() instanceof SpacetimeEqualizer) continue;
            entity.func_70024_g(this.dir.field_72450_a, this.dir.field_72448_b, this.dir.field_72449_c);
        }
    }

    boolean intersectsAnomaly(Vec3 origin, Vec3 dir, Vec3 anomaly, double radius) {
        double v;
        if (origin.func_72438_d(anomaly) <= radius) {
            return true;
        }
        this.intersectDir.field_72450_a = origin.field_72450_a - anomaly.field_72450_a;
        this.intersectDir.field_72448_b = origin.field_72448_b - anomaly.field_72448_b;
        this.intersectDir.field_72449_c = origin.field_72449_c - anomaly.field_72449_c;
        double c = this.intersectDir.func_72433_c();
        double d = radius * radius - (c * c - (v = this.intersectDir.func_72430_b(dir)) * v);
        return !(d < 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void stopSounds() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playSounds() {
        if (this.sound == null) {
            this.sound = new GravitationalAnomalySound(new ResourceLocation("mo:windy"), this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        } else if (!FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.sound)) {
            this.stopSounds();
            this.sound = new GravitationalAnomalySound(new ResourceLocation("mo:windy"), this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.2f, this.getMaxRange());
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void manageSound() {
        if (this.sound == null) {
            this.playSounds();
        } else {
            this.sound.setVolume(Math.min(0.5f, this.getBreakStrength(0.0f, (float)this.getMaxRange()) * 0.1f));
            this.sound.setRange(this.getMaxRange());
        }
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public void onNeighborBlockChange() {
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    @Override
    public void onScan(World world, double x, double y, double z, EntityPlayer player, ItemStack scanner) {
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeCustomNBT(syncData, MachineNBTCategory.ALL_OPTS, false);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound syncData = pkt.func_148857_g();
        if (syncData != null) {
            this.readCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopSounds();
        }
    }

    private boolean onEntityConsume(Entity entity, boolean pre) {
        if (entity instanceof IGravityEntity) {
            ((IGravityEntity)entity).onEntityConsumed(this);
        }
        if (pre) {
            MinecraftForge.EVENT_BUS.post((Event)new MOEventGravitationalAnomalyConsume.Pre(entity, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new MOEventGravitationalAnomalyConsume.Post(entity, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        return true;
    }

    public void manageBlockDestroy(World world) {
        double distance;
        Block block;
        if (!BLOCK_DESTRUCTION) {
            return;
        }
        int solidCount = 0;
        int liquidCount = 0;
        int range = (int)Math.floor(this.getBlockBreakRange());
        double eventHorizon = this.getEventHorizon();
        this.blocks = new PriorityQueue<PositionWrapper>(1, new BlockComparitor(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        if (this.blockDestroyTimer.hasDelayPassed(world, 6)) {
            for (int x = -range; x < range; ++x) {
                for (int y = -range; y < range; ++y) {
                    for (int z = -range; z < range; ++z) {
                        int blockPosX = this.field_145851_c + x;
                        int blockPosY = this.field_145848_d + y;
                        int blockPosZ = this.field_145849_e + z;
                        block = this.getBlock(world, blockPosX, blockPosY, blockPosZ);
                        distance = MOMathHelper.distance(blockPosX, blockPosY, blockPosZ, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        float hardness = block.func_149712_f(world, blockPosX, blockPosY, blockPosZ);
                        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
                            hardness = 1.0f;
                        }
                        float strength = this.getBreakStrength((float)distance, range);
                        if (block == null || block == Blocks.field_150350_a || !(distance <= (double)range) || !(hardness >= 0.0f) || !(distance < eventHorizon) && !(hardness < strength)) continue;
                        this.blocks.add(new PositionWrapper(blockPosX, blockPosY, blockPosZ));
                    }
                }
            }
        }
        for (PositionWrapper position : this.blocks) {
            block = world.func_147439_a(position.x, position.y, position.z);
            if (this.cleanFlowingLiquids(block, position.x, position.y, position.z)) continue;
            if (liquidCount < 32 && this.cleanLiquids(block, position.x, position.y, position.z)) {
                ++liquidCount;
                continue;
            }
            if (solidCount >= 6) continue;
            try {
                distance = MOMathHelper.distance(position.x, position.y, position.z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                float strength = this.getBreakStrength((float)distance, range);
                if (!this.brakeBlock(world, position.x, position.y, position.z, strength, eventHorizon, range)) continue;
                ++solidCount;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while trying to brake block %s", block);
            }
        }
    }

    public void consume(Entity entity) {
        if (!entity.field_70128_L && this.onEntityConsume(entity, true)) {
            boolean consumedFlag = false;
            if (entity instanceof EntityItem) {
                consumedFlag |= this.consumeEntityItem((EntityItem)entity);
            } else if (entity instanceof EntityFallingBlock) {
                consumedFlag |= this.consumeFallingBlock((EntityFallingBlock)entity);
            } else if (entity instanceof EntityLivingBase) {
                consumedFlag |= this.consumeLivingEntity((EntityLivingBase)entity, this.getBreakStrength((float)entity.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e), (float)this.getMaxRange()));
            }
            if (consumedFlag) {
                this.onEntityConsume(entity, false);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    private boolean consumeEntityItem(EntityItem entityItem) {
        ItemStack itemStack = entityItem.func_92059_d();
        if (itemStack != null) {
            try {
                this.mass = Math.addExact(this.mass, (long)MatterHelper.getMatterAmountFromItem(itemStack) * (long)itemStack.field_77994_a);
            }
            catch (ArithmeticException e) {
                return false;
            }
            entityItem.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)entityItem);
            if (entityItem.func_92059_d().func_77973_b().equals(Items.field_151156_bN)) {
                this.collapse();
            }
            return true;
        }
        return false;
    }

    private boolean consumeFallingBlock(EntityFallingBlock fallingBlock) {
        ItemStack itemStack = new ItemStack(fallingBlock.func_145805_f(), 1, fallingBlock.field_145814_a);
        if (itemStack != null) {
            try {
                this.mass = Math.addExact(this.mass, (long)MatterHelper.getMatterAmountFromItem(itemStack) * (long)itemStack.field_77994_a);
            }
            catch (ArithmeticException e) {
                return false;
            }
            fallingBlock.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)fallingBlock);
            return true;
        }
        return false;
    }

    private boolean consumeLivingEntity(EntityLivingBase entity, float strength) {
        try {
            this.mass = Math.addExact(this.mass, (long)Math.min(entity.func_110143_aJ(), strength));
        }
        catch (ArithmeticException e) {
            return false;
        }
        if (entity.func_110143_aJ() <= strength && !(entity instanceof EntityPlayer)) {
            entity.func_70106_y();
            this.field_145850_b.func_72900_e((Entity)entity);
        }
        DamageSource damageSource = new DamageSource("blackHole");
        entity.func_70097_a(damageSource, strength);
        return true;
    }

    public boolean brakeBlock(World world, int x, int y, int z, float strength, double eventHorizon, int range) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return true;
        }
        float hardness = block.func_149712_f(this.field_145850_b, x, y, z);
        double distance = MOMathHelper.distance(x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (distance <= (double)range && hardness >= 0.0f && (distance < eventHorizon || hardness < strength)) {
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (BLOCK_ENTITIES) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, world.func_72805_g(x, y, z));
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_70145_X = true;
                    world.func_72838_d((Entity)fallingBlock);
                } else {
                    ItemStack bStack = this.createStackedBlock(block, meta);
                    if (bStack != null) {
                        EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, bStack);
                        world.func_72838_d((Entity)item);
                    }
                }
                block.func_149749_a(world, x, y, z, block, 0);
                this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 10);
                return true;
            }
            int matter = 0;
            if (block.canSilkHarvest(this.field_145850_b, null, x, y, z, meta)) {
                matter += MatterHelper.getMatterAmountFromItem(this.createStackedBlock(block, meta));
            } else {
                for (Object stack : block.getDrops(this.field_145850_b, x, y, z, meta, 0)) {
                    matter += MatterHelper.getMatterAmountFromItem((ItemStack)stack);
                }
            }
            this.field_145850_b.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            List result = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 2), (double)(z - 2), (double)(x + 3), (double)(y + 3), (double)(z + 3)));
            for (EntityItem entityItem : result) {
                this.consumeEntityItem(entityItem);
            }
            try {
                this.mass = Math.addExact(this.mass, (long)matter);
            }
            catch (ArithmeticException e) {
                return false;
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 10);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    protected ItemStack createStackedBlock(Block block, int meta) {
        Item item;
        if (block != null && (item = Item.func_150898_a((Block)block)) != null) {
            if (item.func_77614_k()) {
                return new ItemStack(item, 1, meta);
            }
            return new ItemStack(item, 1, 0);
        }
        return null;
    }

    public boolean cleanLiquids(Block block, int x, int y, int z) {
        if (block instanceof IFluidBlock && FORGE_FLUIDS) {
            if (((IFluidBlock)block).canDrain(this.field_145850_b, x, y, z)) {
                if (FALLING_BLOCKS) {
                    EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, this.field_145850_b.func_72805_g(x, y, z));
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_70145_X = true;
                    this.field_145850_b.func_72838_d((Entity)fallingBlock);
                }
                ((IFluidBlock)block).drain(this.field_145850_b, x, y, z, true);
                return true;
            }
        } else if (block instanceof BlockLiquid && VANILLA_FLUIDS && this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2)) {
            if (FALLING_BLOCKS) {
                EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, this.field_145850_b.func_72805_g(x, y, z));
                fallingBlock.field_145812_b = 1;
                fallingBlock.field_70145_X = true;
                this.field_145850_b.func_72838_d((Entity)fallingBlock);
            }
            return true;
        }
        return false;
    }

    public boolean cleanFlowingLiquids(Block block, int x, int y, int z) {
        if (VANILLA_FLUIDS && (block == Blocks.field_150358_i || block == Blocks.field_150356_k)) {
            return this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
        return false;
    }

    private Vec3 normalize(Vec3 vec3) {
        double d0 = MathHelper.func_76133_a((double)(vec3.field_72450_a * vec3.field_72450_a + vec3.field_72448_b * vec3.field_72448_b + vec3.field_72449_c * vec3.field_72449_c));
        if (d0 < 1.0E-4) {
            vec3.field_72450_a = 0.0;
            vec3.field_72448_b = 0.0;
            vec3.field_72449_c = 0.0;
        } else {
            vec3.field_72450_a /= d0;
            vec3.field_72448_b /= d0;
            vec3.field_72449_c /= d0;
        }
        return vec3;
    }

    @Override
    public void collapse() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (float)this.getRealMassUnsuppressed() * 2.0f, true);
    }

    @Override
    public void addInfo(World world, double x, double y, double z, List<String> infos) {
        DecimalFormat format = new DecimalFormat("#.##");
        infos.add("Mass: " + this.mass);
        infos.add("Range: " + format.format(this.getMaxRange()));
        infos.add("Brake Range: " + format.format(this.getBlockBreakRange()));
        infos.add("Horizon: " + format.format(this.getEventHorizon()));
        infos.add("Brake Lvl: " + format.format(this.getBreakStrength()));
    }

    @Override
    public void suppress(AnomalySuppressor suppressor) {
        for (AnomalySuppressor s : this.supressors) {
            if (!s.update(suppressor)) continue;
            return;
        }
        this.supressors.add(suppressor);
    }

    private float calculateSuppression() {
        float suppression = 1.0f;
        Iterator<AnomalySuppressor> iterator = this.supressors.iterator();
        while (iterator.hasNext()) {
            AnomalySuppressor s = iterator.next();
            boolean isLoaded = this.field_145850_b.func_72938_d((int)s.getX(), (int)s.getZ()).field_76636_d;
            if (!s.isValid() && isLoaded) {
                iterator.remove();
            }
            if (isLoaded) {
                s.tick();
            }
            suppression *= s.getAmount();
        }
        return suppression;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74772_a("Mass", this.mass);
            nbt.func_74776_a("Suppression", this.suppression);
            if (toDisk) {
                NBTTagList suppressors = new NBTTagList();
                for (AnomalySuppressor s : this.supressors) {
                    NBTTagCompound suppressorTag = new NBTTagCompound();
                    s.writeToNBT(suppressorTag);
                    suppressors.func_74742_a((NBTBase)suppressorTag);
                }
                nbt.func_74782_a("suppressors", (NBTBase)suppressors);
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.supressors.clear();
            this.mass = nbt.func_74763_f("Mass");
            this.suppression = nbt.func_74760_g("Suppression");
            NBTTagList suppressors = nbt.func_150295_c("suppressors", 10);
            for (int i = 0; i < this.supressors.size(); ++i) {
                NBTTagCompound suppressorTag = suppressors.func_150305_b(i);
                AnomalySuppressor s = new AnomalySuppressor(suppressorTag);
                this.supressors.add(s);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.max(Math.pow(this.getMaxRange(), 3.0), 2048.0);
    }

    public Block getBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public double getEventHorizon() {
        return Math.max(13.34768 * this.getRealMass() / 8.987551787368176, 0.5);
    }

    @Override
    public double getBlockBreakRange() {
        return this.getMaxRange() / 2.0;
    }

    @Override
    public double getMaxRange() {
        return Math.sqrt(this.getRealMass() * 667.384);
    }

    @Override
    public double getAcceleration(double distanceSq) {
        return 6.67384 * (this.getRealMass() / Math.max(distanceSq, (double)1.0E-4f));
    }

    @Override
    public double getRealMass() {
        return this.getRealMassUnsuppressed() * (double)this.suppression;
    }

    @Override
    public double getRealMassUnsuppressed() {
        return Math.log1p((double)Math.max(this.mass, 0L) * 1.0E-5);
    }

    @Override
    public float getBreakStrength(float distance, float maxRange) {
        return (float)this.getRealMass() * 4.0f * this.suppression * this.getDistanceFalloff(distance, maxRange);
    }

    @Override
    public float getDistanceFalloff(float distance, float maxRange) {
        return 1.0f - distance / maxRange;
    }

    @Override
    public float getBreakStrength() {
        return (float)this.getRealMass() * 4.0f * this.suppression;
    }

    public static class BlockComparitor
    implements Comparator<PositionWrapper> {
        int posX;
        int posY;
        int posZ;

        public BlockComparitor(int x, int y, int z) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        @Override
        public int compare(PositionWrapper o1, PositionWrapper o2) {
            return Double.compare(MOMathHelper.distanceSqured(o1.x, o1.y, o1.z, this.posX, this.posY, this.posZ), MOMathHelper.distanceSqured(o2.x, o2.y, o2.z, this.posX, this.posY, this.posZ));
        }
    }

    public static class PositionWrapper {
        int x;
        int y;
        int z;

        public PositionWrapper(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

