/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.InscriberSlot;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.data.recipes.InscriberRecipe;
import matteroverdrive.handler.recipes.InscriberRecipes;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityInscriber
extends MOTileEntityMachineEnergy {
    @SideOnly(value=Side.CLIENT)
    private float nextHeadX;
    @SideOnly(value=Side.CLIENT)
    private float nextHeadY;
    @SideOnly(value=Side.CLIENT)
    private float lastHeadX;
    @SideOnly(value=Side.CLIENT)
    private float lastHeadY;
    @SideOnly(value=Side.CLIENT)
    private float headAnimationTime;
    private int inscribeTime;
    public static int MAIN_INPUT_SLOT_ID;
    public static int SEC_INPUT_SLOT_ID;
    public static int OUTPUT_SLOT_ID;
    private InscriberRecipe cachedRecipe;

    public TileEntityInscriber() {
        super(4);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxTransfer(256);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        MAIN_INPUT_SLOT_ID = inventory.AddSlot(new InscriberSlot(true, false).setSendToClient(true));
        SEC_INPUT_SLOT_ID = inventory.AddSlot(new InscriberSlot(true, true));
        OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false).setSendToClient(true));
        super.RegisterSlots(inventory);
    }

    protected void manageInscription() {
        if (!this.field_145850_b.field_72995_K && this.isInscribing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick()) {
            ++this.inscribeTime;
            this.energyStorage.modifyEnergyStored(-this.getEnergyDrainPerTick());
            this.UpdateClientPower();
            if (this.inscribeTime >= this.getSpeed()) {
                this.inscribeTime = 0;
                this.inscribeItem();
            }
        }
        if (!this.isInscribing()) {
            this.inscribeTime = 0;
        }
    }

    public boolean canPutInOutput() {
        ItemStack outputStack = this.inventory.func_70301_a(OUTPUT_SLOT_ID);
        return outputStack == null;
    }

    public void inscribeItem() {
        if (this.cachedRecipe != null && this.canPutInOutput()) {
            ItemStack outputSlot = this.inventory.func_70301_a(OUTPUT_SLOT_ID);
            if (outputSlot != null) {
                ++outputSlot.field_77994_a;
            } else {
                this.inventory.func_70299_a(OUTPUT_SLOT_ID, this.cachedRecipe.getCraftingResult(this.inventory.func_70301_a(MAIN_INPUT_SLOT_ID), this.inventory.func_70301_a(SEC_INPUT_SLOT_ID)));
            }
            this.inventory.func_70298_a(MAIN_INPUT_SLOT_ID, 1);
            this.inventory.func_70298_a(SEC_INPUT_SLOT_ID, 1);
            this.calculateRecipe();
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74768_a("inscribeTime", this.inscribeTime);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.inscribeTime = nbt.func_74762_e("inscribeTime");
        }
    }

    @Override
    public boolean getServerActive() {
        return this.isInscribing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick();
    }

    public int getEnergyDrainPerTick() {
        int maxEnergy = this.getEnergyDrainMax();
        int speed = this.getSpeed();
        if (speed > 0) {
            return maxEnergy / speed;
        }
        return 0;
    }

    public int getEnergyDrainMax() {
        if (this.cachedRecipe != null) {
            return (int)((double)this.cachedRecipe.getEnergy() * this.getUpgradeMultiply(UpgradeTypes.PowerUsage));
        }
        return 0;
    }

    public int getSpeed() {
        if (this.cachedRecipe != null) {
            return (int)((double)this.cachedRecipe.getTime() * this.getUpgradeMultiply(UpgradeTypes.Speed));
        }
        return 0;
    }

    public boolean isInscribing() {
        return this.cachedRecipe != null && this.canPutInOutput();
    }

    @Override
    public String getSound() {
        return "machine";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 1.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K && this.isActive()) {
            this.handleHeadAnimation();
        }
        this.manageInscription();
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{MAIN_INPUT_SLOT_ID, SEC_INPUT_SLOT_ID, OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == OUTPUT_SLOT_ID;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type.equals((Object)UpgradeTypes.PowerUsage) || type.equals((Object)UpgradeTypes.Speed) || type.equals((Object)UpgradeTypes.PowerStorage) || type.equals((Object)UpgradeTypes.PowerTransfer);
    }

    @Override
    protected void onAwake(Side side) {
        this.calculateRecipe();
    }

    @Override
    public float getProgress() {
        float speed = this.getSpeed();
        if (speed > 0.0f) {
            return (float)this.inscribeTime / speed;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleHeadAnimation() {
        if (this.headAnimationTime >= 1.0f) {
            this.lastHeadX = this.nextHeadX;
            this.lastHeadY = this.nextHeadY;
            this.nextHeadX = MathHelper.func_76131_a((float)((float)random.nextGaussian()), (float)-1.0f, (float)1.0f);
            this.nextHeadY = MathHelper.func_76131_a((float)((float)random.nextGaussian()), (float)-1.0f, (float)1.0f);
            this.headAnimationTime = 0.0f;
        }
        this.headAnimationTime += 0.05f;
    }

    @SideOnly(value=Side.CLIENT)
    public float geatHeadX() {
        return MOMathHelper.Lerp(this.lastHeadX, this.nextHeadX, this.headAnimationTime);
    }

    @SideOnly(value=Side.CLIENT)
    public float geatHeadY() {
        return MOMathHelper.Lerp(this.lastHeadY, this.nextHeadY, this.headAnimationTime);
    }

    public void calculateRecipe() {
        ItemStack mainStack = this.inventory.func_70301_a(MAIN_INPUT_SLOT_ID);
        ItemStack secStack = this.inventory.func_70301_a(SEC_INPUT_SLOT_ID);
        if (mainStack != null && secStack != null) {
            this.cachedRecipe = InscriberRecipes.getRecipe(mainStack, secStack);
            return;
        }
        this.cachedRecipe = null;
    }

    @Override
    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = super.func_70298_a(slot, size);
        this.calculateRecipe();
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemStack) {
        super.func_70299_a(slot, itemStack);
        this.calculateRecipe();
    }
}

