/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import java.util.Random;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.MatterSlot;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityMachineDecomposer
extends MOTileEntityMachineMatter
implements ISidedInventory {
    public static int MATTER_STORAGE = 1024;
    public static int ENERGY_STORAGE = 512000;
    public static final int MATTER_EXTRACT_SPEED = 32;
    public static final float FAIL_CHANGE = 0.005f;
    public static int DECEOPOSE_SPEED_PER_MATTER = 80;
    public static int DECOMPOSE_ENERGY_PER_MATTER = 8000;
    public int INPUT_SLOT_ID;
    public int OUTPUT_SLOT_ID;
    private TimeTracker time;
    private static Random random = new Random();
    public int decomposeTime;

    public TileEntityMachineDecomposer() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxExtract(ENERGY_STORAGE);
        this.energyStorage.setMaxReceive(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxReceive(0);
        this.matterStorage.setMaxExtract(MATTER_STORAGE);
        this.time = new TimeTracker();
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.INPUT_SLOT_ID = inventory.AddSlot(new MatterSlot(true));
        this.OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false));
        super.RegisterSlots(inventory);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.manageDecompose();
        this.manageExtract();
    }

    @Override
    public String getSound() {
        return "machine";
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 1.0f;
    }

    @Override
    public void onContainerOpen(Side side) {
    }

    private void manageExtract() {
        if (!this.field_145850_b.field_72995_K && this.time.hasDelayPassed(this.field_145850_b, 32)) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection oposite;
                int recived;
                ForgeDirection dir = ForgeDirection.values()[i];
                TileEntity e = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (!(e instanceof IMatterHandler) || (recived = ((IMatterHandler)e).fill(oposite = dir.getOpposite(), new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, this.matterStorage.getFluidAmount()), true)) == 0) continue;
                this.matterStorage.setMatterStored(Math.max(0, this.matterStorage.getMatterStored() - recived));
                this.updateClientMatter();
            }
        }
    }

    protected void manageDecompose() {
        if (!this.field_145850_b.field_72995_K && this.isDecomposing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick()) {
            ++this.decomposeTime;
            this.extractEnergy(ForgeDirection.DOWN, this.getEnergyDrainPerTick(), false);
            if (this.decomposeTime >= this.getSpeed()) {
                this.decomposeTime = 0;
                this.decomposeItem();
            }
        }
        if (!this.isDecomposing()) {
            this.decomposeTime = 0;
        }
    }

    public boolean isDecomposing() {
        int matter = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        return this.getRedstoneActive() && this.func_70301_a(this.INPUT_SLOT_ID) != null && MatterHelper.containsMatter(this.func_70301_a(this.INPUT_SLOT_ID)) && this.func_94041_b(this.INPUT_SLOT_ID, this.func_70301_a(this.INPUT_SLOT_ID)) && matter <= this.getMatterCapacity() - this.getMatterStored() && this.canPutInOutput(matter);
    }

    @Override
    public boolean getServerActive() {
        return this.isDecomposing() && this.energyStorage.getEnergyStored() >= this.getEnergyDrainPerTick();
    }

    public double getFailChance() {
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.Fail);
        return (double)0.005f * upgradeMultiply * upgradeMultiply;
    }

    public int getSpeed() {
        double matter = Math.log1p(MatterHelper.getMatterAmountFromItem(this.inventory.func_70301_a(this.INPUT_SLOT_ID)));
        matter *= matter;
        return (int)Math.round((double)DECEOPOSE_SPEED_PER_MATTER * matter * this.getUpgradeMultiply(UpgradeTypes.Speed));
    }

    public int getEnergyDrainPerTick() {
        int maxEnergy = this.getEnergyDrainMax();
        int speed = this.getSpeed();
        if (speed > 0) {
            return maxEnergy / speed;
        }
        return 0;
    }

    public int getEnergyDrainMax() {
        int matter = MatterHelper.getMatterAmountFromItem(this.inventory.func_70301_a(this.INPUT_SLOT_ID));
        double upgradeMultiply = this.getUpgradeMultiply(UpgradeTypes.PowerUsage);
        return (int)Math.round((double)(matter * DECOMPOSE_ENERGY_PER_MATTER) * upgradeMultiply);
    }

    private boolean canPutInOutput(int matter) {
        ItemStack stack = this.func_70301_a(this.OUTPUT_SLOT_ID);
        if (stack == null) {
            return true;
        }
        return stack.func_77973_b() == MatterOverdriveItems.matter_dust && stack.func_77960_j() == matter && stack.field_77994_a < stack.func_77976_d();
    }

    private void failDecompose() {
        ItemStack stack = this.func_70301_a(this.OUTPUT_SLOT_ID);
        int matter = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        if (stack != null) {
            if (stack.func_77973_b() == MatterOverdriveItems.matter_dust && stack.func_77960_j() == matter && stack.field_77994_a < stack.func_77976_d()) {
                ++stack.field_77994_a;
            }
        } else {
            stack = new ItemStack((Item)MatterOverdriveItems.matter_dust);
            MatterOverdriveItems.matter_dust.setMatter(stack, matter);
            this.func_70299_a(this.OUTPUT_SLOT_ID, stack);
        }
    }

    private void decomposeItem() {
        int matterAmount = MatterHelper.getMatterAmountFromItem(this.func_70301_a(this.INPUT_SLOT_ID));
        if (this.func_70301_a(this.INPUT_SLOT_ID) != null && this.canPutInOutput(matterAmount)) {
            if ((double)random.nextFloat() < this.getFailChance()) {
                this.failDecompose();
            } else {
                int matter = this.matterStorage.getMatterStored();
                this.matterStorage.setMatterStored(matterAmount + matter);
                this.updateClientMatter();
            }
            this.func_70298_a(this.INPUT_SLOT_ID, 1);
            this.forceSync();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.decomposeTime = nbt.func_74765_d("DecomposeTime");
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74777_a("DecomposeTime", (short)this.decomposeTime);
        }
    }

    @Override
    protected void onActiveChange() {
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{this.INPUT_SLOT_ID, this.OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack item, int j) {
        return i != this.INPUT_SLOT_ID;
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        return 0;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type != UpgradeTypes.Range && type != UpgradeTypes.SecondOutput;
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Override
    public float getProgress() {
        float speed = this.getSpeed();
        if (speed > 0.0f) {
            return (float)this.decomposeTime / speed;
        }
        return 0.0f;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }
}

