/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.compat.modules.waila.IWailaBodyProvider;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.ItemInventoryWrapper;
import matteroverdrive.data.inventory.ModuleSlot;
import matteroverdrive.data.inventory.WeaponSlot;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.WeaponHelper;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TileEntityWeaponStation
extends MOTileEntityMachine
implements IWailaBodyProvider {
    public int INPUT_SLOT;
    public int BATTERY_MODULE;
    public int COLOR_MODULE;
    public int BARREL_MODULE;
    public int SIGHTS_MODULE;
    public int OTHER_MODULE;

    public TileEntityWeaponStation() {
        super(0);
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        WeaponSlot weaponSlot = new WeaponSlot(true);
        this.BATTERY_MODULE = inventory.AddSlot(new ModuleSlot(false, 0, weaponSlot));
        this.COLOR_MODULE = inventory.AddSlot(new ModuleSlot(false, 1, weaponSlot));
        this.BARREL_MODULE = inventory.AddSlot(new ModuleSlot(false, 2, weaponSlot));
        this.SIGHTS_MODULE = inventory.AddSlot(new ModuleSlot(false, 3, weaponSlot));
        this.OTHER_MODULE = inventory.AddSlot(new ModuleSlot(false, 4, weaponSlot));
        this.INPUT_SLOT = inventory.AddSlot(weaponSlot);
        super.RegisterSlots(inventory);
    }

    public IInventory getActiveInventory() {
        if (this.inventory.getSlot(this.INPUT_SLOT).getItem() != null && WeaponHelper.isWeapon(this.inventory.getSlot(this.INPUT_SLOT).getItem())) {
            return new ItemInventoryWrapper(this.inventory.getSlot(this.INPUT_SLOT).getItem(), 5);
        }
        return this.inventory;
    }

    @Override
    public String getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onActiveChange() {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        if (slot != this.INPUT_SLOT) {
            return this.getActiveInventory().func_70301_a(slot);
        }
        return super.func_70301_a(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot != this.INPUT_SLOT) {
            return this.getActiveInventory().func_94041_b(slot, item);
        }
        return super.func_94041_b(slot, item);
    }

    @Override
    public ItemStack func_70298_a(int slot, int size) {
        if (slot != this.INPUT_SLOT) {
            return this.getActiveInventory().func_70298_a(slot, size);
        }
        return super.func_70298_a(slot, size);
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (slot != this.INPUT_SLOT) {
            return this.getActiveInventory().func_70304_b(slot);
        }
        return super.func_70304_b(slot);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot != this.INPUT_SLOT) {
            this.getActiveInventory().func_70299_a(slot, itemStack);
        } else {
            super.func_70299_a(slot, itemStack);
        }
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileEntityWeaponStation) {
            TileEntityWeaponStation weaponStation = (TileEntityWeaponStation)te;
            if (weaponStation.func_70301_a(this.INPUT_SLOT) != null) {
                String name = weaponStation.func_70301_a(this.INPUT_SLOT).func_82833_r();
                currenttip.add(EnumChatFormatting.YELLOW + "Current Weapon: " + EnumChatFormatting.WHITE + name);
            }
        } else {
            throw new RuntimeException("Weapon Station WAILA provider is being used for something that is not a Weapon Station: " + te.getClass());
        }
        return currenttip;
    }
}

