/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile.pipes;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.transport.IPipe;
import matteroverdrive.data.MatterStorage;
import matteroverdrive.data.transport.FluidPipeNetwork;
import matteroverdrive.data.transport.IFluidPipe;
import matteroverdrive.fluids.FluidMatterPlasma;
import matteroverdrive.init.MatterOverdriveFluids;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.tile.pipes.TileEntityPipe;
import matteroverdrive.util.FluidNetworkHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityMatterPipe
extends TileEntityPipe
implements IFluidPipe {
    protected MatterStorage storage;
    protected FluidPipeNetwork fluidPipeNetwork;
    public static Random rand = new Random();
    protected int transferSpeed = 10;
    TimeTracker t = new TimeTracker();

    public TileEntityMatterPipe() {
        this.storage = new MatterStorage(32);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.manageNetwork();
            this.manageTransfer();
        }
    }

    public void manageNetwork() {
        if (this.fluidPipeNetwork == null) {
            FluidNetworkHelper.getFluidPipeNetworkFromPool().addPipe(this);
        }
        FluidPipeNetwork lastNetwork = null;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof IFluidPipe) || lastNetwork != null && (((IFluidPipe)tileEntity).getNetwork() == null || lastNetwork.getNetworkPipes().size() >= ((FluidPipeNetwork)((IFluidPipe)tileEntity).getNetwork()).getNetworkPipes().size())) continue;
            lastNetwork = (FluidPipeNetwork)((IFluidPipe)tileEntity).getNetwork();
        }
        if (lastNetwork != null && lastNetwork != this.getNetwork()) {
            lastNetwork.addPipe(this);
        }
    }

    public void manageTransfer() {
        if (this.getMatterStored() > 0 && this.getNetwork() != null) {
            for (IFluidPipe pipe : this.getNetwork().getFluidHandlers()) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity fluidHandler = pipe.getTile().func_145831_w().func_147438_o(pipe.getTile().field_145851_c + direction.offsetX, pipe.getTile().field_145848_d + direction.offsetY, pipe.getTile().field_145849_e + direction.offsetZ);
                    if (fluidHandler == null || !(fluidHandler instanceof IFluidHandler) || fluidHandler instanceof IFluidPipe || this.getMatterStored() <= 0 || !((IFluidHandler)fluidHandler).canFill(ForgeDirection.UNKNOWN, (Fluid)MatterOverdriveFluids.matterPlasma)) continue;
                    this.extractMatter(ForgeDirection.UNKNOWN, ((IFluidHandler)fluidHandler).fill(ForgeDirection.UNKNOWN, new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, this.getMatterStored()), true), false);
                }
            }
        }
    }

    @Override
    public boolean canConnectTo(TileEntity entity, ForgeDirection direction) {
        if (entity != null && entity instanceof IFluidHandler) {
            return ((IFluidHandler)entity).canDrain(direction, (Fluid)MatterOverdriveFluids.matterPlasma) || ((IFluidHandler)entity).canFill(direction, (Fluid)MatterOverdriveFluids.matterPlasma);
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (!this.field_145850_b.field_72995_K && categories.contains((Object)MachineNBTCategory.DATA) && toDisk) {
            this.storage.writeToNBT(comp);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.storage.readFromNBT(comp);
        }
    }

    @Override
    protected void onAwake(Side side) {
    }

    @Override
    public int getMatterStored() {
        return this.storage.getMatterStored();
    }

    @Override
    public int getMatterCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        return this.storage.receiveMatter(side, amount, simulate);
    }

    @Override
    public int extractMatter(ForgeDirection direction, int amount, boolean simulate) {
        return this.storage.extractMatter(direction, amount, simulate);
    }

    @Override
    public void onAdded(World world, int x, int y, int z) {
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
    }

    @Override
    public void onDestroyed() {
        if (this.getNetwork() != null) {
            this.getNetwork().destroyPipe(this);
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storage.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.storage.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storage.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid instanceof FluidMatterPlasma;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.storage.getInfo()};
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public void onNetworkUpdate() {
    }

    @Override
    public FluidPipeNetwork getNetwork() {
        return this.fluidPipeNetwork;
    }

    @Override
    public void setNetwork(FluidPipeNetwork network) {
        this.fluidPipeNetwork = network;
    }

    @Override
    public List<IPipe<FluidPipeNetwork>> getConnections() {
        ArrayList<IPipe<FluidPipeNetwork>> connections = new ArrayList<IPipe<FluidPipeNetwork>>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof IFluidPipe)) continue;
            connections.add((IFluidPipe)tileEntity);
        }
        return connections;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        if (this.getNetwork() != null) {
            this.getNetwork().networkUpdate(this);
        }
    }
}

