/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.Stack;
import matteroverdrive.data.transport.FluidPipeNetwork;
import matteroverdrive.util.MOLog;

public class FluidNetworkHelper {
    private static final int MAX_POOL_SIZE = 32;
    private static Stack<FluidPipeNetwork> fluidPipeNetworksPool = new Stack();

    public static FluidPipeNetwork getFluidPipeNetworkFromPool() {
        if (fluidPipeNetworksPool.size() > 0) {
            return fluidPipeNetworksPool.pop();
        }
        return new FluidPipeNetwork();
    }

    public static void addFluidPipeToPool(FluidPipeNetwork pipeNetwork) {
        if (fluidPipeNetworksPool.size() > 32) {
            MOLog.warn("Fluid Pipe Network pool reached max size of %s", 32);
        } else {
            fluidPipeNetworksPool.push(pipeNetwork);
        }
    }
}

