/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MOBlockHelper {
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};

    public static int getLeftSide(int side) {
        return SIDE_LEFT[side];
    }

    public static int getRightSide(int side) {
        return SIDE_RIGHT[side];
    }

    public static int getOppositeSide(int side) {
        return SIDE_OPPOSITE[side];
    }

    public static int getAboveSide(int side) {
        return SIDE_ABOVE[side];
    }

    public static int getBelowSide(int side) {
        return SIDE_BELOW[side];
    }

    public static int determineXZPlaceFacing(EntityLivingBase placer) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (rotation) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 3;
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, ForgeDirection direction) {
        return world != null && world.func_72899_e(x, y, z) ? world.func_147438_o(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ) : null;
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, int side) {
        return world == null ? null : MOBlockHelper.getAdjacentTileEntity(world, x, y, z, ForgeDirection.values()[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection direction) {
        return tileEntity == null ? null : MOBlockHelper.getAdjacentTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, direction);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, int direction) {
        return tileEntity == null ? null : MOBlockHelper.getAdjacentTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, ForgeDirection.values()[direction]);
    }

    public static final class RotationType {
        public static final int PREVENT = -1;
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

