/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.List;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponColor;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.items.weapon.module.WeaponModuleColor;
import matteroverdrive.util.MOInventoryHelper;
import net.minecraft.item.ItemStack;

public class WeaponHelper {
    public static ItemStack getModuleAtSlot(int slot, ItemStack weapon) {
        if (WeaponHelper.isWeapon(weapon)) {
            return MOInventoryHelper.getStackInSlot(weapon, slot);
        }
        return null;
    }

    public static boolean hasModule(int module, ItemStack weapon) {
        return MOInventoryHelper.getStackInSlot(weapon, module) != null;
    }

    public static void setModuleAtSlot(int slot, ItemStack weapon, ItemStack module) {
        if (WeaponHelper.isWeapon(weapon) && module != null) {
            MOInventoryHelper.setInventorySlotContents(weapon, slot, module);
        }
    }

    public static int getColor(ItemStack weapon) {
        ItemStack module = WeaponHelper.getModuleAtSlot(1, weapon);
        if (module != null && WeaponHelper.isWeaponModule(module)) {
            return ((IWeaponColor)module.func_77973_b()).getColor(module, weapon);
        }
        return WeaponModuleColor.defaultColor.getColor();
    }

    public static float modifyStat(int stat, ItemStack weapon, float original) {
        List<ItemStack> itemStacks;
        if (WeaponHelper.isWeapon(weapon) && (itemStacks = MOInventoryHelper.getStacks(weapon)) != null) {
            for (ItemStack module : itemStacks) {
                if (module == null || !(module.func_77973_b() instanceof IWeaponModule)) continue;
                original = ((IWeaponModule)module.func_77973_b()).modifyWeaponStat(stat, module, weapon, original);
            }
        }
        return original;
    }

    public static boolean hasStat(int stat, ItemStack weapon) {
        float statValue = 1.0f;
        if (WeaponHelper.isWeapon(weapon)) {
            for (ItemStack module : MOInventoryHelper.getStacks(weapon)) {
                if (module == null || !(module.func_77973_b() instanceof IWeaponModule)) continue;
                statValue = ((IWeaponModule)module.func_77973_b()).modifyWeaponStat(stat, module, weapon, statValue);
            }
        }
        return statValue != 1.0f;
    }

    public static boolean isWeaponModule(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IWeaponModule;
    }

    public static boolean isWeapon(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof IWeapon;
    }
}

