/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.Random;
import matteroverdrive.data.world.GenPositionWorldData;
import matteroverdrive.data.world.WorldPosition2D;
import matteroverdrive.util.MOLog;
import matteroverdrive.world.IMOWorldGenBuilding;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.MOWorldGen;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.logging.log4j.Level;

public abstract class MOWorldGenBuilding
extends MOImageGen
implements IMOWorldGenBuilding {
    int yOffset = -1;
    int maxDistanceToAir = 2;
    String name;
    protected Block[] validSpawnBlocks;

    public MOWorldGenBuilding(String name, ResourceLocation texture, int layerWidth, int layerHeight) {
        super(texture, layerWidth, layerHeight);
        this.name = name;
        this.validSpawnBlocks = new Block[]{Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d};
    }

    @Override
    public void generate(Random random, int x, int y, int z, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider, int layer, int placeNotify) {
        this.generateFromImage(world, random, x, y + this.getYOffset(), z, layer, placeNotify);
    }

    public boolean locationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        Block check = world.func_147439_a(i, j, k);
        while (check != Blocks.field_150350_a) {
            if (distanceToAir > this.getMaxDistanceToAir()) {
                return false;
            }
            check = world.func_147439_a(i, j + ++distanceToAir, k);
        }
        Block block = world.func_147439_a(i, j += distanceToAir - 1, k);
        Block blockAbove = world.func_147439_a(i, j + 1, k);
        Block blockBelow = world.func_147439_a(i, j - 1, k);
        for (Block x : this.getValidSpawnBlocks()) {
            if (blockAbove != Blocks.field_150350_a) {
                return false;
            }
            if (block == x) {
                return true;
            }
            if (block != Blocks.field_150433_aE || blockBelow != x) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setMaxDistanceToAir(int maxDistanceToAir) {
        this.maxDistanceToAir = maxDistanceToAir;
    }

    protected int getMaxDistanceToAir() {
        return this.maxDistanceToAir;
    }

    protected Block[] getValidSpawnBlocks() {
        return this.validSpawnBlocks;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    protected abstract void onGeneration(Random var1, World var2, int var3, int var4, int var5);

    protected abstract boolean shouldGenerate(Random var1, World var2, int var3, int var4, int var5);

    public abstract void onGenerationWorkerCreated(WorldGenBuildingWorker var1);

    protected boolean isLocationValid(World world, int x, int y, int z) {
        return this.locationIsValidSpawn(world, x, y, z) && this.locationIsValidSpawn(world, x + this.layerWidth, y, z) && this.locationIsValidSpawn(world, x + this.layerWidth, y, z + this.layerHeight) && this.locationIsValidSpawn(world, x, y, z + this.layerHeight);
    }

    public boolean isFarEnoughFromOthers(World world, int x, int z, int minDistance) {
        GenPositionWorldData worldData = MOWorldGen.getWorldPositionData(world);
        if (worldData != null) {
            return worldData.isFarEnough(this.getName(), x, z, minDistance);
        }
        return true;
    }

    public WorldGenBuildingWorker createWorker(Random random, int x, int y, int z, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        WorldGenBuildingWorker worldGenBuildingWorker = new WorldGenBuildingWorker(this, random, x, y, z, world, chunkGenerator, chunkProvider);
        this.onGenerationWorkerCreated(worldGenBuildingWorker);
        GenPositionWorldData data = MOWorldGen.getWorldPositionData(world);
        data.addPosition(this.getName(), new WorldPosition2D(x + this.layerWidth / 2, z + this.layerHeight / 2));
        return worldGenBuildingWorker;
    }

    public static class WorldGenBuildingWorker {
        int currentLayer;
        Random random;
        int x;
        int y;
        int z;
        World world;
        IChunkProvider chunkGenerator;
        IChunkProvider chunkProvider;
        MOWorldGenBuilding worldGenBuilding;
        int placeNotify;

        public WorldGenBuildingWorker() {
        }

        public WorldGenBuildingWorker(MOWorldGenBuilding worldGenBuilding, Random random, int x, int y, int z, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
            this.init(worldGenBuilding, random, x, y, z, world, chunkGenerator, chunkProvider);
        }

        public WorldGenBuildingWorker init(MOWorldGenBuilding worldGenBuilding, Random random, int x, int y, int z, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
            this.worldGenBuilding = worldGenBuilding;
            this.worldGenBuilding.manageTextureLoading();
            this.x = x;
            this.y = y;
            this.z = z;
            this.random = random;
            this.world = world;
            this.chunkGenerator = chunkGenerator;
            this.chunkProvider = chunkProvider;
            this.placeNotify = this.worldGenBuilding.placeNotify;
            return this;
        }

        public boolean generate() {
            try {
                if (this.currentLayer >= this.worldGenBuilding.getLayerCount()) {
                    this.worldGenBuilding.onGeneration(this.random, this.world, this.x, this.y, this.z);
                    return true;
                }
                this.worldGenBuilding.generate(this.random, this.x, this.y, this.z, this.world, this.chunkGenerator, this.chunkProvider, this.currentLayer, this.placeNotify);
                ++this.currentLayer;
                return false;
            }
            catch (Exception e) {
                MOLog.log(Level.ERROR, e, "There was a problem while generating layer %s of %s", this.currentLayer, this.worldGenBuilding.getName());
                return false;
            }
        }

        public WorldGenBuildingWorker setPlaceNotify(int placeNotify) {
            this.placeNotify = placeNotify;
            return this;
        }
    }
}

