/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.blocks.BlockTritaniumCrate;
import matteroverdrive.blocks.BlockWeaponStation;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.WeaponFactory;
import matteroverdrive.world.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class MOWorldGenCrashedSpaceShip
extends MOWorldGenBuilding {
    private static final int MIN_DISTANCE_APART = 512;
    private String[] holoTexts = new String[]{"Critical\nError", "Contacting\nSection 9", "System\nFailure", "Emergency\nPower\nOffline", "System\nReboot\nFailure", "Help Me", "I Need\nWater"};

    public MOWorldGenCrashedSpaceShip(String name) {
        super(name, new ResourceLocation("mo:textures/world/crashed_space_ship.png"), 11, 35);
        this.setyOffset(-1);
        this.addMapping(3721439, MatterOverdriveBlocks.decorative_clean);
        this.addMapping(1604491, MatterOverdriveBlocks.decorative_vent_bright);
        this.addMapping(11155679, MatterOverdriveBlocks.forceGlass);
        this.addMapping(65400, new Block[]{Blocks.field_150349_c});
        this.addMapping(14221056, MatterOverdriveBlocks.holoSign);
        this.addMapping(11324160, MatterOverdriveBlocks.holoSign);
        this.addMapping(3708639, MatterOverdriveBlocks.decorative_tritanium_plate);
        this.addMapping(14670136, MatterOverdriveBlocks.decorative_tritanium_plate_stripe);
        this.addMapping(6130091, MatterOverdriveBlocks.decorative_holo_matrix);
        this.addMapping(7804029, MatterOverdriveBlocks.weapon_station);
        this.addMapping(11553424, MatterOverdriveBlocks.tritaniumCrate);
        this.addMapping(9756394, MatterOverdriveBlocks.decorative_separator);
        this.addMapping(16751616, MatterOverdriveBlocks.decorative_coils);
        this.addMapping(11315271, MatterOverdriveBlocks.decorative_matter_tube);
        this.addMapping(801632, MatterOverdriveBlocks.decorative_carbon_fiber_plate);
        this.addMapping(12963536, Blocks.field_150350_a);
    }

    @Override
    public void onBlockPlace(World world, Block block, int x, int y, int z, Random random, int color) {
        TileEntity tileEntity;
        if (block == MatterOverdriveBlocks.holoSign) {
            if (this.colorsMatch(color, 14221056)) {
                world.func_72921_c(x, y, z, ForgeDirection.EAST.ordinal(), 3);
            } else if (this.colorsMatch(color, 11324160)) {
                world.func_72921_c(x, y, z, ForgeDirection.WEST.ordinal(), 3);
            }
            TileEntity tileEntity2 = world.func_147438_o(x, y, z);
            if (tileEntity2 instanceof TileEntityHoloSign && random.nextInt(100) < 30) {
                ((TileEntityHoloSign)tileEntity2).setText(this.holoTexts[random.nextInt(this.holoTexts.length)]);
            }
        } else if (block instanceof BlockTritaniumCrate) {
            TileEntity tileEntity3 = world.func_147438_o(x, y, z);
            if (tileEntity3 instanceof IInventory) {
                WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])ChestGenHooks.getInfo((String)"android_house").getItems(random), (IInventory)((IInventory)tileEntity3), (int)(random.nextInt(10) + 10));
                QuestStack questStack = MatterOverdrive.questFactory.generateQuestStack(random, MatterOverdriveQuests.crashLanding);
                questStack.getTagCompound().func_74783_a("Pos", new int[]{x, y, z});
                MOInventoryHelper.insertItemStackIntoInventory((IInventory)tileEntity3, questStack.getContract(), 0);
            }
        } else if (block instanceof BlockWeaponStation && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityWeaponStation && random.nextInt(200) < 10) {
            ((TileEntityWeaponStation)tileEntity).func_70299_a(((TileEntityWeaponStation)tileEntity).INPUT_SLOT, MatterOverdrive.weaponFactory.getRandomDecoratedEnergyWeapon(new WeaponFactory.WeaponGenerationContext(3, null, true)));
        }
    }

    @Override
    protected void onGeneration(Random random, World world, int x, int y, int z) {
    }

    @Override
    protected boolean shouldGenerate(Random random, World world, int x, int y, int z) {
        return world.field_73011_w.field_76574_g == 0 && this.isFarEnoughFromOthers(world, x, z, 512);
    }

    @Override
    public void onGenerationWorkerCreated(MOWorldGenBuilding.WorldGenBuildingWorker worldGenBuildingWorker) {
    }
}

