/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.Random;
import matteroverdrive.blocks.BlockDecorative;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.world.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.common.util.ForgeDirection;

public class MOWorldGenUnderwaterBase
extends MOWorldGenBuilding {
    private static final int MIN_DISTANCE_APART = 2048;
    NoiseGeneratorSimplex noise;

    public MOWorldGenUnderwaterBase(String name) {
        super(name, new ResourceLocation("mo:textures/world/underwater_base.png"), 43, 43);
        this.validSpawnBlocks = new Block[]{Blocks.field_150355_j};
        this.setyOffset(-24);
        this.noise = new NoiseGeneratorSimplex(new Random());
        for (BlockDecorative blockDecorative : BlockDecorative.decorativeBlocks) {
            this.addMapping(blockDecorative.getBlockColor(0), blockDecorative);
        }
        this.addMapping(14456732, new Block[]{Blocks.field_150329_H});
        this.addMapping(7852470, new Block[]{Blocks.field_150328_O});
        this.addMapping(13826896, MatterOverdriveBlocks.forceGlass);
        this.addMapping(794190, Blocks.field_150458_ak);
        this.addMapping(10988645, MatterOverdriveBlocks.tritaniumCrate[14]);
        this.addMapping(14067476, new Block[]{Blocks.field_150399_cn});
        this.addMapping(2906857, MatterOverdriveBlocks.weapon_station);
        this.addMapping(707980, MatterOverdriveBlocks.androidStation);
        this.addMapping(7346425, MatterOverdriveBlocks.tritaniumCrate[12]);
        this.addMapping(4609996, MatterOverdriveBlocks.tritaniumCrate[10]);
        this.addMapping(2040594, MatterOverdriveBlocks.tritaniumCrate[15]);
        this.addMapping(13842205, MatterOverdriveBlocks.machine_hull);
        this.addMapping(3555577, Blocks.field_150430_aB);
        this.addMapping(15726397, MatterOverdriveBlocks.network_switch);
        this.addMapping(5923720, MatterOverdriveBlocks.boundingBox);
        this.addMapping(12523945, new Block[]{Blocks.field_150349_c});
        this.addMapping(12607070, Blocks.field_150457_bL);
        this.addMapping(5082579, MatterOverdriveBlocks.pattern_monitor);
        this.addMapping(14392378, MatterOverdriveBlocks.holoSign);
        this.addMapping(6862476, MatterOverdriveBlocks.matter_analyzer);
        this.addMapping(2928839, MatterOverdriveBlocks.starMap);
        this.addMapping(1781751, MatterOverdriveBlocks.network_pipe);
        this.addMapping(387755, MatterOverdriveBlocks.tritaniumCrate[11]);
        this.addMapping(1114174, MatterOverdriveBlocks.chargingStation);
        this.addMapping(11738755, Blocks.field_150459_bM);
        this.addMapping(13078135, MatterOverdriveBlocks.replicator);
        this.addMapping(3377730, Blocks.field_150469_bN);
        this.addMapping(12446351, Blocks.field_150468_ap);
        this.addMapping(5051124, MatterOverdriveBlocks.pattern_storage);
        this.addMapping(16241163, Blocks.field_150345_g);
        this.addMapping(8735544, Blocks.field_150454_av);
        this.addMapping(0xFF00FF, Blocks.field_150350_a);
    }

    @Override
    public int getMetaFromColor(int color, Random random) {
        return 255 - this.getAlphaFromColor(color);
    }

    @Override
    protected void onGeneration(Random random, World world, int x, int y, int z) {
    }

    @Override
    protected boolean isLocationValid(World world, int x, int y, int z) {
        return this.isPointDeepEnough(world, x, y, z) && this.isPointDeepEnough(world, x + this.layerWidth, y, z) && this.isPointDeepEnough(world, x + this.layerWidth, y, z + this.layerHeight) && this.isPointDeepEnough(world, x, y, z + this.layerHeight);
    }

    protected boolean isPointDeepEnough(World world, int x, int y, int z) {
        int blocksInWater = 0;
        while (y > 0) {
            if (world.func_147439_a(x, y, z) == Blocks.field_150355_j || world.func_147439_a(x, y, z) == Blocks.field_150358_i) {
                ++blocksInWater;
            } else {
                return blocksInWater > 26;
            }
            --y;
        }
        return false;
    }

    @Override
    protected boolean shouldGenerate(Random random, World world, int x, int y, int z) {
        return world.func_72807_a(x, z).func_150569_a(BiomeGenBase.field_150575_M) && this.isFarEnoughFromOthers(world, x, z, 2048);
    }

    @Override
    public void onGenerationWorkerCreated(MOWorldGenBuilding.WorldGenBuildingWorker worker) {
        int offset = 0;
        for (int yo = worker.y; yo > 0 && !worker.world.isSideSolid(worker.x + this.layerWidth / 2, yo, worker.z + this.layerHeight / 2, ForgeDirection.UP); --yo) {
            --offset;
        }
        this.setyOffset(offset);
    }

    @Override
    public void onBlockPlace(World world, Block block, int x, int y, int z, Random random, int color) {
        if (block == MatterOverdriveBlocks.starMap) {
            EntityMutantScientist mutantScientist = new EntityMutantScientist(world);
            mutantScientist.func_110163_bv();
            mutantScientist.func_70107_b(x, y + 2, z);
            mutantScientist.func_94058_c("Mitko'Urrr");
            world.func_72838_d((Entity)mutantScientist);
        }
    }
}

