/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderThermalEvaporationController
extends TileEntitySpecialRenderer {
    private static Map<SalinationRenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>> cachedCenterFluids = new HashMap<SalinationRenderData, HashMap<Fluid, MekanismRenderer.DisplayInteger[]>>();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityThermalEvaporationController)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityThermalEvaporationController tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity.structured && tileEntity.inputTank.getFluid() != null) {
            SalinationRenderData data = new SalinationRenderData();
            data.height = tileEntity.height - 2;
            data.side = ForgeDirection.getOrientation((int)tileEntity.facing);
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            if (data.height >= 1 && tileEntity.inputTank.getCapacity() > 0) {
                Coord4D renderLoc = tileEntity.getRenderLocation();
                this.push();
                GL11.glTranslated((double)this.getX(renderLoc.xCoord), (double)this.getY(renderLoc.yCoord), (double)this.getZ(renderLoc.zCoord));
                MekanismRenderer.glowOn(tileEntity.inputTank.getFluid().getFluid().getLuminosity());
                MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(data, tileEntity.inputTank.getFluid().getFluid());
                displayList[(int)((float)tileEntity.inputTank.getFluidAmount() / (float)tileEntity.inputTank.getCapacity() * ((float)this.getStages(data.height) - 1.0f))].render();
                MekanismRenderer.glowOff();
                this.pop();
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(SalinationRenderData data, Fluid fluid) {
        if (cachedCenterFluids.containsKey(data) && cachedCenterFluids.get(data).containsKey(fluid)) {
            return cachedCenterFluids.get(data).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(fluid.getIcon());
        int stages = this.getStages(data.height);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        if (cachedCenterFluids.containsKey(data)) {
            cachedCenterFluids.get(data).put(fluid, displays);
        } else {
            HashMap<Fluid, MekanismRenderer.DisplayInteger[]> map = new HashMap<Fluid, MekanismRenderer.DisplayInteger[]>();
            map.put(fluid, displays);
            cachedCenterFluids.put(data, map);
        }
        MekanismRenderer.colorFluid(fluid);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getIcon() != null) {
                switch (data.side) {
                    case NORTH: {
                        toReturn.minX = 0.01;
                        toReturn.minY = 0.01;
                        toReturn.minZ = 0.01;
                        toReturn.maxX = 1.99;
                        toReturn.maxY = (double)((float)i / (float)stages * (float)data.height) - 0.01;
                        toReturn.maxZ = 1.99;
                        break;
                    }
                    case SOUTH: {
                        toReturn.minX = -0.99;
                        toReturn.minY = 0.01;
                        toReturn.minZ = -0.99;
                        toReturn.maxX = 0.99;
                        toReturn.maxY = (double)((float)i / (float)stages * (float)data.height) - 0.01;
                        toReturn.maxZ = 0.99;
                        break;
                    }
                    case WEST: {
                        toReturn.minX = 0.01;
                        toReturn.minY = 0.01;
                        toReturn.minZ = -0.99;
                        toReturn.maxX = 1.99;
                        toReturn.maxY = (double)((float)i / (float)stages * (float)data.height) - 0.01;
                        toReturn.maxZ = 0.99;
                        break;
                    }
                    case EAST: {
                        toReturn.minX = -0.99;
                        toReturn.minY = 0.01;
                        toReturn.minZ = 0.01;
                        toReturn.maxX = 0.99;
                        toReturn.maxY = (double)((float)i / (float)stages * (float)data.height) - 0.01;
                        toReturn.maxZ = 1.99;
                    }
                }
                MekanismRenderer.renderObject(toReturn);
            }
            MekanismRenderer.DisplayInteger cfr_ignored_0 = displays[i];
            MekanismRenderer.DisplayInteger.endList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return displays;
    }

    private int getStages(int height) {
        return height * 6400;
    }

    private double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
    }

    public static class SalinationRenderData {
        public int height;
        public ForgeDirection side;

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.height;
            return code;
        }

        public boolean equals(Object data) {
            return data instanceof SalinationRenderData && ((SalinationRenderData)data).height == this.height && ((SalinationRenderData)data).side == this.side;
        }
    }
}

