/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockBasic;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntitySuperheatingElement;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BoilerUpdateProtocol
extends UpdateProtocol<SynchronizedBoilerData> {
    public static final int WATER_PER_TANK = 16000;
    public static final int STEAM_PER_TANK = 160000;

    public BoilerUpdateProtocol(TileEntityBoilerCasing tileEntity) {
        super(tileEntity);
    }

    @Override
    protected boolean isValidFrame(int x, int y, int z) {
        return BlockBasic.BasicType.get(this.pointer.func_145831_w().func_147439_a(x, y, z), this.pointer.func_145831_w().func_72805_g(x, y, z)) == BlockBasic.BasicType.BOILER_CASING;
    }

    @Override
    protected boolean isValidInnerNode(int x, int y, int z) {
        if (super.isValidInnerNode(x, y, z)) {
            return true;
        }
        TileEntity tile = this.pointer.func_145831_w().func_147438_o(x, y, z);
        return tile instanceof TileEntityPressureDisperser || tile instanceof TileEntitySuperheatingElement;
    }

    @Override
    protected boolean canForm(SynchronizedBoilerData structure) {
        if (structure.volHeight >= 3) {
            HashSet<Coord4D> dispersers = new HashSet<Coord4D>();
            HashSet<Coord4D> elements = new HashSet<Coord4D>();
            for (Coord4D coord : this.innerNodes) {
                TileEntity tile = coord.getTileEntity((IBlockAccess)this.pointer.func_145831_w());
                if (tile instanceof TileEntityPressureDisperser) {
                    dispersers.add(coord);
                    continue;
                }
                if (!(tile instanceof TileEntitySuperheatingElement)) continue;
                structure.internalLocations.add(coord);
                elements.add(coord);
            }
            int prevDispersers = dispersers.size();
            if (dispersers.size() == 0) {
                return false;
            }
            final Coord4D initDisperser = (Coord4D)dispersers.iterator().next();
            for (int x = structure.renderLocation.xCoord + 1; x < structure.renderLocation.xCoord + structure.volLength - 1; ++x) {
                for (int z = structure.renderLocation.zCoord + 1; z < structure.renderLocation.zCoord + structure.volWidth - 1; ++z) {
                    TileEntity tile = this.pointer.func_145831_w().func_147438_o(x, initDisperser.yCoord, z);
                    if (!(tile instanceof TileEntityPressureDisperser)) {
                        return false;
                    }
                    dispersers.remove(new Coord4D(x, initDisperser.yCoord, z, this.pointer.func_145831_w().field_73011_w.field_76574_g));
                }
            }
            if (dispersers.size() > 0) {
                return false;
            }
            if (elements.size() > 0) {
                structure.superheatingElements = new UpdateProtocol.NodeCounter(this, new UpdateProtocol.NodeChecker(){

                    @Override
                    public boolean isValid(Coord4D coord) {
                        return coord.getTileEntity((IBlockAccess)BoilerUpdateProtocol.this.pointer.func_145831_w()) instanceof TileEntitySuperheatingElement;
                    }
                }).calculate((Coord4D)elements.iterator().next());
            }
            if (elements.size() > structure.superheatingElements) {
                return false;
            }
            Coord4D initAir = null;
            int totalAir = 0;
            for (int x = structure.renderLocation.xCoord; x < structure.renderLocation.xCoord + structure.volLength; ++x) {
                for (int y = structure.renderLocation.yCoord; y < initDisperser.yCoord; ++y) {
                    for (int z = structure.renderLocation.zCoord; z < structure.renderLocation.zCoord + structure.volWidth; ++z) {
                        if (!this.pointer.func_145831_w().func_147437_c(x, y, z) && !this.isViableNode(x, y, z)) continue;
                        initAir = new Coord4D(x, y, z, this.pointer.func_145831_w().field_73011_w.field_76574_g);
                        ++totalAir;
                    }
                }
            }
            if (initAir == null) {
                return false;
            }
            final Coord4D renderLocation = structure.renderLocation.clone();
            final int volLength = structure.volLength;
            final int volWidth = structure.volWidth;
            structure.waterVolume = new UpdateProtocol.NodeCounter(this, new UpdateProtocol.NodeChecker(){

                @Override
                public final boolean isValid(Coord4D coord) {
                    return coord.yCoord >= renderLocation.yCoord - 1 && coord.yCoord < initDisperser.yCoord && coord.xCoord >= renderLocation.xCoord && coord.xCoord < renderLocation.xCoord + volLength && coord.zCoord >= renderLocation.zCoord && coord.zCoord < renderLocation.zCoord + volWidth && (coord.isAirBlock((IBlockAccess)BoilerUpdateProtocol.this.pointer.func_145831_w()) || BoilerUpdateProtocol.this.isViableNode(coord.xCoord, coord.yCoord, coord.zCoord));
                }
            }).calculate(initAir);
            if (totalAir > structure.waterVolume) {
                return false;
            }
            int steamHeight = structure.renderLocation.yCoord + structure.volHeight - 2 - initDisperser.yCoord;
            structure.steamVolume = structure.volWidth * structure.volLength * steamHeight;
            structure.upperRenderLocation = new Coord4D(structure.renderLocation.xCoord, initDisperser.yCoord + 1, structure.renderLocation.zCoord, this.pointer.func_145831_w().field_73011_w.field_76574_g);
            return true;
        }
        return false;
    }

    protected BoilerCache getNewCache() {
        return new BoilerCache();
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData();
    }

    @Override
    protected MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedBoilerData> cache, MultiblockCache<SynchronizedBoilerData> merge) {
        if (((BoilerCache)cache).water == null) {
            ((BoilerCache)cache).water = ((BoilerCache)merge).water;
        } else if (((BoilerCache)merge).water != null && ((BoilerCache)cache).water.isFluidEqual(((BoilerCache)merge).water)) {
            ((BoilerCache)cache).water.amount += ((BoilerCache)merge).water.amount;
        }
        if (((BoilerCache)cache).steam == null) {
            ((BoilerCache)cache).steam = ((BoilerCache)merge).steam;
        } else if (((BoilerCache)merge).steam != null && ((BoilerCache)cache).steam.isFluidEqual(((BoilerCache)merge).steam)) {
            ((BoilerCache)cache).steam.amount += ((BoilerCache)merge).steam.amount;
        }
        ((BoilerCache)cache).temperature = Math.max(((BoilerCache)cache).temperature, ((BoilerCache)merge).temperature);
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (((SynchronizedBoilerData)this.structureFound).waterStored != null) {
            ((SynchronizedBoilerData)this.structureFound).waterStored.amount = Math.min(((SynchronizedBoilerData)this.structureFound).waterStored.amount, ((SynchronizedBoilerData)this.structureFound).waterVolume * 16000);
        }
        if (((SynchronizedBoilerData)this.structureFound).steamStored != null) {
            ((SynchronizedBoilerData)this.structureFound).steamStored.amount = Math.min(((SynchronizedBoilerData)this.structureFound).steamStored.amount, ((SynchronizedBoilerData)this.structureFound).steamVolume * 160000);
        }
    }

    @Override
    protected void onStructureCreated(SynchronizedBoilerData structure, int origX, int origY, int origZ, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        for (Coord4D obj : structure.locations) {
            if (!(obj.getTileEntity((IBlockAccess)this.pointer.func_145831_w()) instanceof TileEntityBoilerValve)) continue;
            SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
            data.location = obj;
            data.side = this.getSide(obj, origX + xmin, origX + xmax, origY + ymin, origY + ymax, origZ + zmin, origZ + zmax);
            structure.valves.add(data);
        }
    }
}

