/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.tileentities.TileEntityClipboard;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockClipboard
extends BlockContainer {
    public int clipboardAngle;

    public BlockClipboard() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitx, float hity, float hitz) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.dropItems(world, i, j, k);
                world.func_147468_f(i, j, k);
                return true;
            }
        } else if (world.field_72995_K) {
            int selection = this.getSelectionPointFromFace(face, hitx, hity, hitz);
            ByteBuf buffer = Unpooled.buffer();
            buffer.writeInt(i);
            buffer.writeInt(j);
            buffer.writeInt(k);
            buffer.writeInt(selection);
            BiblioCraft.ch_BiblioClipBlock.sendToServer(new FMLProxyPacket(buffer, "BiblioClipBlock"));
        }
        return false;
    }

    private int getSelectionPointFromFace(int face, float hitx, float hity, float hitz) {
        switch (face) {
            case 2: {
                return this.getSelectionPoint(1.0f - hitx, 1.0f - hity);
            }
            case 3: {
                return this.getSelectionPoint(hitx, 1.0f - hity);
            }
            case 4: {
                return this.getSelectionPoint(hitz, 1.0f - hity);
            }
            case 5: {
                return this.getSelectionPoint(1.0f - hitz, 1.0f - hity);
            }
        }
        return -1;
    }

    private int getSelectionPoint(float x, float y) {
        if (x > 0.21f && x < 0.272f) {
            float spacing = 0.0655f;
            for (int i = 0; i < 9; ++i) {
                if (!((double)y > 0.23 + (double)((float)i * spacing)) || !(y < 0.285f + (float)i * spacing)) continue;
                return i;
            }
        }
        if ((double)y > 0.83 && y < 0.868f) {
            if (x > 0.296f && x < 0.387f) {
                return 10;
            }
            if (x > 0.599f && x < 0.843f) {
                return 11;
            }
        }
        return -1;
    }

    public Item func_149650_a(int meta, Random rando, int par3) {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public float func_149712_f(World world, int i, int j, int k) {
        return 3.0f;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityClipboard) {
            TileEntityClipboard clipboard = (TileEntityClipboard)tile;
            switch (clipboard.getAngle()) {
                case 0: {
                    this.func_149676_a(0.97f, 0.08f, 0.15f, 1.0f, 0.92f, 0.85f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.15f, 0.08f, 0.97f, 0.85f, 0.92f, 1.0f);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.0f, 0.08f, 0.15f, 0.03f, 0.92f, 0.85f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.15f, 0.08f, 0.0f, 0.85f, 0.92f, 0.03f);
                }
            }
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.clipboardRenderID;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        this.clipboardAngle = angle %= 4;
        TileEntityClipboard tile = (TileEntityClipboard)world.func_147438_o(i, j, k);
        tile.setAngle(this.clipboardAngle);
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        this.dropItems(world, i, j, k);
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            EntityItem entityItem = new EntityItem(world, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return new TileEntityClipboard();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityClipboard) {
            TileEntityClipboard te = (TileEntityClipboard)tile;
            int angle = te.getAngle();
            switch (axis) {
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }
}

