/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;

public class TileEntityWeaponRack
extends TileEntity
implements IInventory {
    private ItemStack[] rackInventory = new ItemStack[4];
    public int rackAngle;
    public boolean shifted = false;
    public int showWText = 0;
    public boolean islocked = false;
    public String lockee = "";
    public String customTex = "none";
    public ResourceLocation customTexture = null;

    public void setShift(boolean shift) {
        this.shifted = shift;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getShift() {
        return this.shifted;
    }

    public void setCustomTex(String tex) {
        this.customTex = tex;
        this.customTexture = tex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ResourceLocation getCustomTex() {
        if (this.customTexture != null) {
            return this.customTexture;
        }
        return CommonProxy.PLANKSOAK;
    }

    public String getCustomTexString() {
        return this.customTex;
    }

    public boolean canUpdate() {
        return false;
    }

    public void setShowWText(int weaponNum) {
        this.showWText = weaponNum;
    }

    public int getShowWText() {
        return this.showWText;
    }

    public int func_70302_i_() {
        return this.rackInventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.rackInventory[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.rackInventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tagList = nbt.func_150295_c("RackInventory", 10);
        this.rackInventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.rackInventory.length) continue;
            this.rackInventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.rackAngle = nbt.func_74762_e("rackAngle");
        this.islocked = nbt.func_74767_n("locked");
        this.lockee = nbt.func_74779_i("lockee");
        this.customTex = nbt.func_74779_i("customTexture");
        this.shifted = nbt.func_74767_n("shifted");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.rackInventory.length; ++i) {
            ItemStack stack = this.rackInventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("RackInventory", (NBTBase)itemList);
        nbt.func_74768_a("rackAngle", this.rackAngle);
        nbt.func_74757_a("locked", this.islocked);
        nbt.func_74778_a("lockee", this.lockee);
        nbt.func_74778_a("customTexture", this.customTex);
        nbt.func_74757_a("shifted", this.shifted);
    }

    public String func_145825_b() {
        return "jds.tileentitytoolrack";
    }

    public boolean checkSlot(int slot) {
        return this.func_70301_a(slot) != null;
    }

    public void setAngle(int angle) {
        this.rackAngle = angle;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getAngle() {
        return this.rackAngle;
    }

    public ItemStack getTool(int slot) {
        ItemStack tool = this.rackInventory[slot];
        if (tool != null) {
            return tool;
        }
        return null;
    }

    public void removeTool(int slot) {
        if (this.rackInventory[slot] != null) {
            this.func_70299_a(slot, null);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean addTool(int slot, ItemStack stack) {
        if (this.rackInventory[slot] == null) {
            this.func_70299_a(slot, stack);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public boolean isLocked() {
        return this.islocked;
    }

    public void setLocked(boolean locked) {
        this.islocked = locked;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String getLockee() {
        return this.lockee;
    }

    public void setLockee(String lockeeperson) {
        this.lockee = lockeeperson;
    }

    public Packet func_145844_m() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74768_a("rackAngle", this.rackAngle);
        dataTag.func_74778_a("customTexture", this.customTex);
        dataTag.func_74757_a("shifted", this.shifted);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.rackInventory.length; ++i) {
            ItemStack stack = this.rackInventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        dataTag.func_74782_a("PotionInventory", (NBTBase)itemList);
        dataTag.func_74757_a("locked", this.islocked);
        dataTag.func_74778_a("lockee", this.lockee);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, dataTag);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.rackAngle = nbtData.func_74762_e("rackAngle");
        this.islocked = nbtData.func_74767_n("locked");
        this.lockee = nbtData.func_74779_i("lockee");
        this.customTex = nbtData.func_74779_i("customTexture");
        this.shifted = nbtData.func_74767_n("shifted");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        NBTTagList tagList = nbtData.func_150295_c("PotionInventory", 10);
        this.rackInventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.rackInventory.length) continue;
            this.rackInventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackitem = itemstack.func_77973_b();
        return stackitem != null && TileEntityWeaponRack.isItemTool(stackitem, itemstack);
    }

    public static boolean isItemTool(Item tool, ItemStack stack) {
        String toolName = tool.func_77653_i(stack);
        String toolcodeName = tool.toString();
        return tool instanceof ItemTool || tool instanceof ItemSword || tool instanceof ItemBow || tool instanceof ItemHoe || tool instanceof ItemFishingRod || tool instanceof ItemShears || tool instanceof ItemFlintAndSteel || Config.testToolValidity(toolName, toolcodeName);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        return bb;
    }
}

