/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements;

import com.builtbroken.ai.improvements.FastTrig;
import com.builtbroken.ai.improvements.FixedEntityLookHelper;
import com.builtbroken.ai.improvements.overrides.OverrideHandler;
import com.builtbroken.ai.improvements.overrides.instances.EntityOverrideArrowAttack;
import com.builtbroken.ai.improvements.overrides.instances.EntityOverrideAttackOnCollide;
import com.builtbroken.ai.improvements.util.CheckFakeWorld;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModDisabledEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="aiimprovements", name="AI Improvements", version="0.0.1.8", acceptableRemoteVersions="*", canBeDeactivated=true)
public class AIImprovements {
    public static Logger LOGGER;
    public static boolean REMOVE_LOOK_AI;
    public static boolean REMOVE_LOOK_IDLE;
    public static boolean REPLACE_LOOK_HELPER;
    public static File configFolder;
    public static CheckFakeWorld fakeWorld;
    Configuration config;

    @Mod.EventHandler
    public void disableEvent(FMLModDisabledEvent event) {
        LOGGER.info("Disabling mod");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = LogManager.getLogger((String)"AI_Improvements");
        fakeWorld = CheckFakeWorld.newWorld("fakeWorld");
        configFolder = new File(event.getModConfigurationDirectory(), "bbm/AI_Improvements");
        File oldConfig = new File(event.getModConfigurationDirectory(), "AI_Improvements.cfg");
        File newConfig = new File(configFolder, "AI_Improvements.cfg");
        if (oldConfig.exists() && !newConfig.exists()) {
            LOGGER.info("Moving old config file " + oldConfig + " to " + newConfig);
            try {
                Files.move(oldConfig.toPath(), newConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
                oldConfig.delete();
            }
            catch (IOException e) {
                LOGGER.error("Failed to move config");
                e.printStackTrace();
            }
        }
        this.config = new Configuration(newConfig);
        this.config.load();
        REMOVE_LOOK_AI = this.config.getBoolean("RemoveEntityAIWatchClosest", "general", REMOVE_LOOK_AI, "Disables the AI segment that controls entities looking at the closest player");
        REMOVE_LOOK_IDLE = this.config.getBoolean("RemoveEntityAILookIdle", "general", REMOVE_LOOK_IDLE, "Disables the AI segment that controls entities looking at random locations");
        REPLACE_LOOK_HELPER = this.config.getBoolean("ReplaceLookHelper", "general", REPLACE_LOOK_HELPER, "Replaces the EntityLookHelper with a more CPU efficient version");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OverrideHandler.registerOverride(new EntityOverrideAttackOnCollide());
        OverrideHandler.registerOverride(new EntityOverrideArrowAttack());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FastTrig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)OverrideHandler.INSTANCE);
        OverrideHandler.INSTANCE.init(this.config);
        this.config.save();
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            if (REMOVE_LOOK_AI || REMOVE_LOOK_IDLE) {
                Iterator it = living.field_70714_bg.field_75782_a.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EntityAITasks.EntityAITaskEntry)) continue;
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                    if (REMOVE_LOOK_AI && task.field_75733_a instanceof EntityAIWatchClosest) {
                        it.remove();
                        continue;
                    }
                    if (!REMOVE_LOOK_IDLE || !(task.field_75733_a instanceof EntityAILookIdle)) continue;
                    it.remove();
                }
            }
            if (REPLACE_LOOK_HELPER && (living.func_70671_ap() == null || living.func_70671_ap().getClass() == EntityLookHelper.class)) {
                EntityLookHelper oldHelper = living.field_70749_g;
                living.field_70749_g = new FixedEntityLookHelper(living);
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75656_e = oldHelper.field_75656_e;
                living.field_70749_g.field_75655_d = oldHelper.field_75655_d;
                living.field_70749_g.field_75658_c = oldHelper.field_75658_c;
                living.field_70749_g.field_75657_b = oldHelper.field_75657_b;
            }
        }
    }

    static {
        REMOVE_LOOK_AI = false;
        REMOVE_LOOK_IDLE = false;
        REPLACE_LOOK_HELPER = true;
    }
}

