/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.ai;

import com.builtbroken.ai.improvements.overrides.instances.EntityOverrideArrowAttack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;

public class EntityAIArrowAttackOverride
extends EntityAIBase {
    public final EntityLiving entityHost;
    public final IRangedAttackMob rangedAttackEntityHost;
    public double entityMoveSpeed;
    public int minRangedAttackTime;
    public int maxRangedAttackTime;
    public float attackRange;
    public float attackRangeSQ;
    private int lostTargetTimer;
    private int rangedAttackTime = -1;
    private EntityLivingBase attackTarget;

    public EntityAIArrowAttackOverride(IRangedAttackMob host, EntityOverrideArrowAttack.ArrowAttackSettings settings) {
        if (!(host instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = host;
        this.entityHost = (EntityLiving)host;
        this.entityMoveSpeed = settings.entityMoveSpeed;
        this.minRangedAttackTime = settings.minRangedAttackTime;
        this.maxRangedAttackTime = settings.maxRangedAttackTime;
        this.attackRange = settings.attackRange;
        this.attackRangeSQ = this.attackRange * this.attackRange;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.lostTargetTimer = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double distanceSQ = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean canSeeTarget = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.lostTargetTimer = canSeeTarget ? ++this.lostTargetTimer : 0;
        if (distanceSQ <= (double)this.attackRangeSQ && this.lostTargetTimer >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            float scale;
            if (distanceSQ > (double)this.attackRangeSQ || !canSeeTarget) {
                return;
            }
            float actualAttackPower = scale = MathHelper.func_76133_a((double)distanceSQ) / this.attackRange;
            if (scale < 0.1f) {
                actualAttackPower = 0.1f;
            } else if (actualAttackPower > 1.0f) {
                actualAttackPower = 1.0f;
            }
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, actualAttackPower);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(scale * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        } else if (this.rangedAttackTime < 0) {
            float scale = MathHelper.func_76133_a((double)distanceSQ) / this.attackRange;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(scale * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        }
    }
}

